/**
 * Copyright 2021 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef MINDSPORE_NNACL_SQUARED_DIFFERENCE_H_
#define MINDSPORE_NNACL_SQUARED_DIFFERENCE_H_

#ifdef ENABLE_NEON
#include <arm_neon.h>
#endif
#include "nnacl_c/op_base.h"
#include "nnacl_c/base/arithmetic_base.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Element Squared Difference */
int ElementSquaredDifference(const float *in0, const float *in1, float *out, int size);
int ElementOptSquaredDifference(const float *in0, const float *in1, float *out, int size, bool scale);
#ifdef __cplusplus
}
#endif

#endif  // MINDSPORE_NNACL_SQUARED_DIFFERENCE_H_
