/**
 * Copyright 2021 Huawei Technologies Co., Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef NNACL_FP16_LAYER_NORM_FP16_H_
#define NNACL_FP16_LAYER_NORM_FP16_H_

#include "nnacl_c/op_base.h"
#include "nnacl_c/kernel/layer_norm.h"

#ifdef __cplusplus
extern "C" {
#endif

int LayerNormFp16(const float16_t *src_data, const float16_t *gamma_data, const float16_t *beta_data,
                  float16_t *dst_data, float16_t *out_mean, float16_t *out_variance, const LayerNormComputeParam *param,
                  int task_id, int thread_num);
#ifdef __cplusplus
}
#endif

#endif  //   NNACL_FP16_LAYER_NORM_FP16_H_
