// automatically generated by the FlatBuffers compiler, do not modify


#ifndef FLATBUFFERS_GENERATED_MODEL_MINDSPORE_SCHEMA_H_
#define FLATBUFFERS_GENERATED_MODEL_MINDSPORE_SCHEMA_H_

#include "flatbuffers/flatbuffers.h"

#include "ops_types_generated.h"
#include "ops_generated.h"

namespace mindspore {
namespace schema {

struct QuantParam;
struct QuantParamBuilder;

struct ExternalData;
struct ExternalDataBuilder;

struct Tensor;
struct TensorBuilder;

struct Primitive;
struct PrimitiveBuilder;

struct CNode;
struct CNodeBuilder;

struct SubGraph;
struct SubGraphBuilder;

struct MetaGraph;
struct MetaGraphBuilder;

enum WeightQuantCompressType : int32_t {
  WeightQuantCompressType_NONE = 0,
  WeightQuantCompressType_INDEXING = 1,
  WeightQuantCompressType_SPARSE = 2,
  WeightQuantCompressType_FSE = 3,
  WeightQuantCompressType_BITPACKING = 4,
  WeightQuantCompressType_FSE_INT = 5,
  WeightQuantCompressType_FSE_INFER = 6,
  WeightQuantCompressType_MIN = WeightQuantCompressType_NONE,
  WeightQuantCompressType_MAX = WeightQuantCompressType_FSE_INFER
};

inline const WeightQuantCompressType (&EnumValuesWeightQuantCompressType())[7] {
  static const WeightQuantCompressType values[] = {
    WeightQuantCompressType_NONE,
    WeightQuantCompressType_INDEXING,
    WeightQuantCompressType_SPARSE,
    WeightQuantCompressType_FSE,
    WeightQuantCompressType_BITPACKING,
    WeightQuantCompressType_FSE_INT,
    WeightQuantCompressType_FSE_INFER
  };
  return values;
}

inline const char * const *EnumNamesWeightQuantCompressType() {
  static const char * const names[8] = {
    "NONE",
    "INDEXING",
    "SPARSE",
    "FSE",
    "BITPACKING",
    "FSE_INT",
    "FSE_INFER",
    nullptr
  };
  return names;
}

inline const char *EnumNameWeightQuantCompressType(WeightQuantCompressType e) {
  if (flatbuffers::IsOutRange(e, WeightQuantCompressType_NONE, WeightQuantCompressType_FSE_INFER)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesWeightQuantCompressType()[index];
}

enum QuantType : int32_t {
  QuantType_QUANT_NONE = 0,
  QuantType_AwareTraining = 1,
  QuantType_WeightQuant = 2,
  QuantType_PostTraining = 3,
  QuantType_QUANT_WEIGHT = 4,
  QuantType_QUANT_ALL = 5,
  QuantType_QUANT_DYNAMIC = 6,
  QuantType_MIN = QuantType_QUANT_NONE,
  QuantType_MAX = QuantType_QUANT_DYNAMIC
};

inline const QuantType (&EnumValuesQuantType())[7] {
  static const QuantType values[] = {
    QuantType_QUANT_NONE,
    QuantType_AwareTraining,
    QuantType_WeightQuant,
    QuantType_PostTraining,
    QuantType_QUANT_WEIGHT,
    QuantType_QUANT_ALL,
    QuantType_QUANT_DYNAMIC
  };
  return values;
}

inline const char * const *EnumNamesQuantType() {
  static const char * const names[8] = {
    "QUANT_NONE",
    "AwareTraining",
    "WeightQuant",
    "PostTraining",
    "QUANT_WEIGHT",
    "QUANT_ALL",
    "QUANT_DYNAMIC",
    nullptr
  };
  return names;
}

inline const char *EnumNameQuantType(QuantType e) {
  if (flatbuffers::IsOutRange(e, QuantType_QUANT_NONE, QuantType_QUANT_DYNAMIC)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesQuantType()[index];
}

struct QuantParam FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef QuantParamBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_SCALE = 4,
    VT_ZEROPOINT = 6,
    VT_MIN = 8,
    VT_MAX = 10,
    VT_NARROWRANGE = 12,
    VT_NUMBITS = 14,
    VT_INITED = 16,
    VT_VARCORR = 18,
    VT_MEANCORR = 20,
    VT_DSTDTYPE = 22,
    VT_ROUNDTYPE = 24,
    VT_MULTIPLIER = 26
  };
  double scale() const {
    return GetField<double>(VT_SCALE, 1.0);
  }
  int32_t zeroPoint() const {
    return GetField<int32_t>(VT_ZEROPOINT, 0);
  }
  double min() const {
    return GetField<double>(VT_MIN, 0.0);
  }
  double max() const {
    return GetField<double>(VT_MAX, 0.0);
  }
  bool narrowRange() const {
    return GetField<uint8_t>(VT_NARROWRANGE, 1) != 0;
  }
  int32_t numBits() const {
    return GetField<int32_t>(VT_NUMBITS, 8);
  }
  bool inited() const {
    return GetField<uint8_t>(VT_INITED, 0) != 0;
  }
  float varCorr() const {
    return GetField<float>(VT_VARCORR, 1.0f);
  }
  float meanCorr() const {
    return GetField<float>(VT_MEANCORR, 0.0f);
  }
  int32_t dstDtype() const {
    return GetField<int32_t>(VT_DSTDTYPE, 32);
  }
  int32_t roundType() const {
    return GetField<int32_t>(VT_ROUNDTYPE, 1);
  }
  int32_t multiplier() const {
    return GetField<int32_t>(VT_MULTIPLIER, 1);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<double>(verifier, VT_SCALE) &&
           VerifyField<int32_t>(verifier, VT_ZEROPOINT) &&
           VerifyField<double>(verifier, VT_MIN) &&
           VerifyField<double>(verifier, VT_MAX) &&
           VerifyField<uint8_t>(verifier, VT_NARROWRANGE) &&
           VerifyField<int32_t>(verifier, VT_NUMBITS) &&
           VerifyField<uint8_t>(verifier, VT_INITED) &&
           VerifyField<float>(verifier, VT_VARCORR) &&
           VerifyField<float>(verifier, VT_MEANCORR) &&
           VerifyField<int32_t>(verifier, VT_DSTDTYPE) &&
           VerifyField<int32_t>(verifier, VT_ROUNDTYPE) &&
           VerifyField<int32_t>(verifier, VT_MULTIPLIER) &&
           verifier.EndTable();
  }
};

struct QuantParamBuilder {
  typedef QuantParam Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_scale(double scale) {
    fbb_.AddElement<double>(QuantParam::VT_SCALE, scale, 1.0);
  }
  void add_zeroPoint(int32_t zeroPoint) {
    fbb_.AddElement<int32_t>(QuantParam::VT_ZEROPOINT, zeroPoint, 0);
  }
  void add_min(double min) {
    fbb_.AddElement<double>(QuantParam::VT_MIN, min, 0.0);
  }
  void add_max(double max) {
    fbb_.AddElement<double>(QuantParam::VT_MAX, max, 0.0);
  }
  void add_narrowRange(bool narrowRange) {
    fbb_.AddElement<uint8_t>(QuantParam::VT_NARROWRANGE, static_cast<uint8_t>(narrowRange), 1);
  }
  void add_numBits(int32_t numBits) {
    fbb_.AddElement<int32_t>(QuantParam::VT_NUMBITS, numBits, 8);
  }
  void add_inited(bool inited) {
    fbb_.AddElement<uint8_t>(QuantParam::VT_INITED, static_cast<uint8_t>(inited), 0);
  }
  void add_varCorr(float varCorr) {
    fbb_.AddElement<float>(QuantParam::VT_VARCORR, varCorr, 1.0f);
  }
  void add_meanCorr(float meanCorr) {
    fbb_.AddElement<float>(QuantParam::VT_MEANCORR, meanCorr, 0.0f);
  }
  void add_dstDtype(int32_t dstDtype) {
    fbb_.AddElement<int32_t>(QuantParam::VT_DSTDTYPE, dstDtype, 32);
  }
  void add_roundType(int32_t roundType) {
    fbb_.AddElement<int32_t>(QuantParam::VT_ROUNDTYPE, roundType, 1);
  }
  void add_multiplier(int32_t multiplier) {
    fbb_.AddElement<int32_t>(QuantParam::VT_MULTIPLIER, multiplier, 1);
  }
  explicit QuantParamBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<QuantParam> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<QuantParam>(end);
    return o;
  }
};

inline flatbuffers::Offset<QuantParam> CreateQuantParam(
    flatbuffers::FlatBufferBuilder &_fbb,
    double scale = 1.0,
    int32_t zeroPoint = 0,
    double min = 0.0,
    double max = 0.0,
    bool narrowRange = true,
    int32_t numBits = 8,
    bool inited = false,
    float varCorr = 1.0f,
    float meanCorr = 0.0f,
    int32_t dstDtype = 32,
    int32_t roundType = 1,
    int32_t multiplier = 1) {
  QuantParamBuilder builder_(_fbb);
  builder_.add_max(max);
  builder_.add_min(min);
  builder_.add_scale(scale);
  builder_.add_multiplier(multiplier);
  builder_.add_roundType(roundType);
  builder_.add_dstDtype(dstDtype);
  builder_.add_meanCorr(meanCorr);
  builder_.add_varCorr(varCorr);
  builder_.add_numBits(numBits);
  builder_.add_zeroPoint(zeroPoint);
  builder_.add_inited(inited);
  builder_.add_narrowRange(narrowRange);
  return builder_.Finish();
}

struct ExternalData FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef ExternalDataBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_CHECKSUM = 4,
    VT_LOCATION = 6,
    VT_OFFSET = 8,
    VT_LENGTH = 10
  };
  const flatbuffers::String *checkSum() const {
    return GetPointer<const flatbuffers::String *>(VT_CHECKSUM);
  }
  const flatbuffers::String *location() const {
    return GetPointer<const flatbuffers::String *>(VT_LOCATION);
  }
  int64_t offset() const {
    return GetField<int64_t>(VT_OFFSET, 0);
  }
  int64_t length() const {
    return GetField<int64_t>(VT_LENGTH, -1LL);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_CHECKSUM) &&
           verifier.VerifyString(checkSum()) &&
           VerifyOffset(verifier, VT_LOCATION) &&
           verifier.VerifyString(location()) &&
           VerifyField<int64_t>(verifier, VT_OFFSET) &&
           VerifyField<int64_t>(verifier, VT_LENGTH) &&
           verifier.EndTable();
  }
};

struct ExternalDataBuilder {
  typedef ExternalData Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_checkSum(flatbuffers::Offset<flatbuffers::String> checkSum) {
    fbb_.AddOffset(ExternalData::VT_CHECKSUM, checkSum);
  }
  void add_location(flatbuffers::Offset<flatbuffers::String> location) {
    fbb_.AddOffset(ExternalData::VT_LOCATION, location);
  }
  void add_offset(int64_t offset) {
    fbb_.AddElement<int64_t>(ExternalData::VT_OFFSET, offset, 0);
  }
  void add_length(int64_t length) {
    fbb_.AddElement<int64_t>(ExternalData::VT_LENGTH, length, -1LL);
  }
  explicit ExternalDataBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<ExternalData> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<ExternalData>(end);
    return o;
  }
};

inline flatbuffers::Offset<ExternalData> CreateExternalData(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> checkSum = 0,
    flatbuffers::Offset<flatbuffers::String> location = 0,
    int64_t offset = 0,
    int64_t length = -1LL) {
  ExternalDataBuilder builder_(_fbb);
  builder_.add_length(length);
  builder_.add_offset(offset);
  builder_.add_location(location);
  builder_.add_checkSum(checkSum);
  return builder_.Finish();
}

inline flatbuffers::Offset<ExternalData> CreateExternalDataDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *checkSum = nullptr,
    const char *location = nullptr,
    int64_t offset = 0,
    int64_t length = -1LL) {
  auto checkSum__ = checkSum ? _fbb.CreateString(checkSum) : 0;
  auto location__ = location ? _fbb.CreateString(location) : 0;
  return mindspore::schema::CreateExternalData(
      _fbb,
      checkSum__,
      location__,
      offset,
      length);
}

struct Tensor FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef TensorBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_NODETYPE = 4,
    VT_DATATYPE = 6,
    VT_DIMS = 8,
    VT_FORMAT = 10,
    VT_REFCOUNT = 12,
    VT_OFFSET = 14,
    VT_DATA = 16,
    VT_QUANTPARAMS = 18,
    VT_QUANTCLUSTERS = 20,
    VT_NAME = 22,
    VT_ENABLEHUFFMANCODE = 24,
    VT_WEIGHTQUANTCOMPRESSTYPE = 26,
    VT_EXTERNALDATA = 28
  };
  int32_t nodeType() const {
    return GetField<int32_t>(VT_NODETYPE, 0);
  }
  int32_t dataType() const {
    return GetField<int32_t>(VT_DATATYPE, 0);
  }
  const flatbuffers::Vector<int32_t> *dims() const {
    return GetPointer<const flatbuffers::Vector<int32_t> *>(VT_DIMS);
  }
  mindspore::schema::Format format() const {
    return static_cast<mindspore::schema::Format>(GetField<int32_t>(VT_FORMAT, 0));
  }
  int32_t refCount() const {
    return GetField<int32_t>(VT_REFCOUNT, 0);
  }
  int32_t offset() const {
    return GetField<int32_t>(VT_OFFSET, 0);
  }
  const flatbuffers::Vector<uint8_t> *data() const {
    return GetPointer<const flatbuffers::Vector<uint8_t> *>(VT_DATA);
  }
  const flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::QuantParam>> *quantParams() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::QuantParam>> *>(VT_QUANTPARAMS);
  }
  const flatbuffers::Vector<float> *quantClusters() const {
    return GetPointer<const flatbuffers::Vector<float> *>(VT_QUANTCLUSTERS);
  }
  const flatbuffers::String *name() const {
    return GetPointer<const flatbuffers::String *>(VT_NAME);
  }
  bool enableHuffmanCode() const {
    return GetField<uint8_t>(VT_ENABLEHUFFMANCODE, 0) != 0;
  }
  mindspore::schema::WeightQuantCompressType weightQuantCompressType() const {
    return static_cast<mindspore::schema::WeightQuantCompressType>(GetField<int32_t>(VT_WEIGHTQUANTCOMPRESSTYPE, 0));
  }
  const flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::ExternalData>> *externalData() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::ExternalData>> *>(VT_EXTERNALDATA);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int32_t>(verifier, VT_NODETYPE) &&
           VerifyField<int32_t>(verifier, VT_DATATYPE) &&
           VerifyOffset(verifier, VT_DIMS) &&
           verifier.VerifyVector(dims()) &&
           VerifyField<int32_t>(verifier, VT_FORMAT) &&
           VerifyField<int32_t>(verifier, VT_REFCOUNT) &&
           VerifyField<int32_t>(verifier, VT_OFFSET) &&
           VerifyOffset(verifier, VT_DATA) &&
           verifier.VerifyVector(data()) &&
           VerifyOffset(verifier, VT_QUANTPARAMS) &&
           verifier.VerifyVector(quantParams()) &&
           verifier.VerifyVectorOfTables(quantParams()) &&
           VerifyOffset(verifier, VT_QUANTCLUSTERS) &&
           verifier.VerifyVector(quantClusters()) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyField<uint8_t>(verifier, VT_ENABLEHUFFMANCODE) &&
           VerifyField<int32_t>(verifier, VT_WEIGHTQUANTCOMPRESSTYPE) &&
           VerifyOffset(verifier, VT_EXTERNALDATA) &&
           verifier.VerifyVector(externalData()) &&
           verifier.VerifyVectorOfTables(externalData()) &&
           verifier.EndTable();
  }
};

struct TensorBuilder {
  typedef Tensor Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_nodeType(int32_t nodeType) {
    fbb_.AddElement<int32_t>(Tensor::VT_NODETYPE, nodeType, 0);
  }
  void add_dataType(int32_t dataType) {
    fbb_.AddElement<int32_t>(Tensor::VT_DATATYPE, dataType, 0);
  }
  void add_dims(flatbuffers::Offset<flatbuffers::Vector<int32_t>> dims) {
    fbb_.AddOffset(Tensor::VT_DIMS, dims);
  }
  void add_format(mindspore::schema::Format format) {
    fbb_.AddElement<int32_t>(Tensor::VT_FORMAT, static_cast<int32_t>(format), 0);
  }
  void add_refCount(int32_t refCount) {
    fbb_.AddElement<int32_t>(Tensor::VT_REFCOUNT, refCount, 0);
  }
  void add_offset(int32_t offset) {
    fbb_.AddElement<int32_t>(Tensor::VT_OFFSET, offset, 0);
  }
  void add_data(flatbuffers::Offset<flatbuffers::Vector<uint8_t>> data) {
    fbb_.AddOffset(Tensor::VT_DATA, data);
  }
  void add_quantParams(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::QuantParam>>> quantParams) {
    fbb_.AddOffset(Tensor::VT_QUANTPARAMS, quantParams);
  }
  void add_quantClusters(flatbuffers::Offset<flatbuffers::Vector<float>> quantClusters) {
    fbb_.AddOffset(Tensor::VT_QUANTCLUSTERS, quantClusters);
  }
  void add_name(flatbuffers::Offset<flatbuffers::String> name) {
    fbb_.AddOffset(Tensor::VT_NAME, name);
  }
  void add_enableHuffmanCode(bool enableHuffmanCode) {
    fbb_.AddElement<uint8_t>(Tensor::VT_ENABLEHUFFMANCODE, static_cast<uint8_t>(enableHuffmanCode), 0);
  }
  void add_weightQuantCompressType(mindspore::schema::WeightQuantCompressType weightQuantCompressType) {
    fbb_.AddElement<int32_t>(Tensor::VT_WEIGHTQUANTCOMPRESSTYPE, static_cast<int32_t>(weightQuantCompressType), 0);
  }
  void add_externalData(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::ExternalData>>> externalData) {
    fbb_.AddOffset(Tensor::VT_EXTERNALDATA, externalData);
  }
  explicit TensorBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<Tensor> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Tensor>(end);
    return o;
  }
};

inline flatbuffers::Offset<Tensor> CreateTensor(
    flatbuffers::FlatBufferBuilder &_fbb,
    int32_t nodeType = 0,
    int32_t dataType = 0,
    flatbuffers::Offset<flatbuffers::Vector<int32_t>> dims = 0,
    mindspore::schema::Format format = mindspore::schema::Format_NCHW,
    int32_t refCount = 0,
    int32_t offset = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint8_t>> data = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::QuantParam>>> quantParams = 0,
    flatbuffers::Offset<flatbuffers::Vector<float>> quantClusters = 0,
    flatbuffers::Offset<flatbuffers::String> name = 0,
    bool enableHuffmanCode = false,
    mindspore::schema::WeightQuantCompressType weightQuantCompressType = mindspore::schema::WeightQuantCompressType_NONE,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::ExternalData>>> externalData = 0) {
  TensorBuilder builder_(_fbb);
  builder_.add_externalData(externalData);
  builder_.add_weightQuantCompressType(weightQuantCompressType);
  builder_.add_name(name);
  builder_.add_quantClusters(quantClusters);
  builder_.add_quantParams(quantParams);
  builder_.add_data(data);
  builder_.add_offset(offset);
  builder_.add_refCount(refCount);
  builder_.add_format(format);
  builder_.add_dims(dims);
  builder_.add_dataType(dataType);
  builder_.add_nodeType(nodeType);
  builder_.add_enableHuffmanCode(enableHuffmanCode);
  return builder_.Finish();
}

inline flatbuffers::Offset<Tensor> CreateTensorDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    int32_t nodeType = 0,
    int32_t dataType = 0,
    const std::vector<int32_t> *dims = nullptr,
    mindspore::schema::Format format = mindspore::schema::Format_NCHW,
    int32_t refCount = 0,
    int32_t offset = 0,
    const std::vector<uint8_t> *data = nullptr,
    const std::vector<flatbuffers::Offset<mindspore::schema::QuantParam>> *quantParams = nullptr,
    const std::vector<float> *quantClusters = nullptr,
    const char *name = nullptr,
    bool enableHuffmanCode = false,
    mindspore::schema::WeightQuantCompressType weightQuantCompressType = mindspore::schema::WeightQuantCompressType_NONE,
    const std::vector<flatbuffers::Offset<mindspore::schema::ExternalData>> *externalData = nullptr) {
  auto dims__ = dims ? _fbb.CreateVector<int32_t>(*dims) : 0;
  auto data__ = data ? _fbb.CreateVector<uint8_t>(*data) : 0;
  auto quantParams__ = quantParams ? _fbb.CreateVector<flatbuffers::Offset<mindspore::schema::QuantParam>>(*quantParams) : 0;
  auto quantClusters__ = quantClusters ? _fbb.CreateVector<float>(*quantClusters) : 0;
  auto name__ = name ? _fbb.CreateString(name) : 0;
  auto externalData__ = externalData ? _fbb.CreateVector<flatbuffers::Offset<mindspore::schema::ExternalData>>(*externalData) : 0;
  return mindspore::schema::CreateTensor(
      _fbb,
      nodeType,
      dataType,
      dims__,
      format,
      refCount,
      offset,
      data__,
      quantParams__,
      quantClusters__,
      name__,
      enableHuffmanCode,
      weightQuantCompressType,
      externalData__);
}

struct Primitive FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef PrimitiveBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_VALUE_TYPE = 4,
    VT_VALUE = 6
  };
  mindspore::schema::PrimitiveType value_type() const {
    return static_cast<mindspore::schema::PrimitiveType>(GetField<uint8_t>(VT_VALUE_TYPE, 0));
  }
  const void *value() const {
    return GetPointer<const void *>(VT_VALUE);
  }
  template<typename T> const T *value_as() const;
  const mindspore::schema::Abs *value_as_Abs() const {
    return value_type() == mindspore::schema::PrimitiveType_Abs ? static_cast<const mindspore::schema::Abs *>(value()) : nullptr;
  }
  const mindspore::schema::Activation *value_as_Activation() const {
    return value_type() == mindspore::schema::PrimitiveType_Activation ? static_cast<const mindspore::schema::Activation *>(value()) : nullptr;
  }
  const mindspore::schema::ActivationGrad *value_as_ActivationGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_ActivationGrad ? static_cast<const mindspore::schema::ActivationGrad *>(value()) : nullptr;
  }
  const mindspore::schema::Adam *value_as_Adam() const {
    return value_type() == mindspore::schema::PrimitiveType_Adam ? static_cast<const mindspore::schema::Adam *>(value()) : nullptr;
  }
  const mindspore::schema::AddFusion *value_as_AddFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_AddFusion ? static_cast<const mindspore::schema::AddFusion *>(value()) : nullptr;
  }
  const mindspore::schema::AdderFusion *value_as_AdderFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_AdderFusion ? static_cast<const mindspore::schema::AdderFusion *>(value()) : nullptr;
  }
  const mindspore::schema::AddGrad *value_as_AddGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_AddGrad ? static_cast<const mindspore::schema::AddGrad *>(value()) : nullptr;
  }
  const mindspore::schema::AddN *value_as_AddN() const {
    return value_type() == mindspore::schema::PrimitiveType_AddN ? static_cast<const mindspore::schema::AddN *>(value()) : nullptr;
  }
  const mindspore::schema::All *value_as_All() const {
    return value_type() == mindspore::schema::PrimitiveType_All ? static_cast<const mindspore::schema::All *>(value()) : nullptr;
  }
  const mindspore::schema::ApplyMomentum *value_as_ApplyMomentum() const {
    return value_type() == mindspore::schema::PrimitiveType_ApplyMomentum ? static_cast<const mindspore::schema::ApplyMomentum *>(value()) : nullptr;
  }
  const mindspore::schema::ArgMaxFusion *value_as_ArgMaxFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_ArgMaxFusion ? static_cast<const mindspore::schema::ArgMaxFusion *>(value()) : nullptr;
  }
  const mindspore::schema::ArgMinFusion *value_as_ArgMinFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_ArgMinFusion ? static_cast<const mindspore::schema::ArgMinFusion *>(value()) : nullptr;
  }
  const mindspore::schema::Assert *value_as_Assert() const {
    return value_type() == mindspore::schema::PrimitiveType_Assert ? static_cast<const mindspore::schema::Assert *>(value()) : nullptr;
  }
  const mindspore::schema::Assign *value_as_Assign() const {
    return value_type() == mindspore::schema::PrimitiveType_Assign ? static_cast<const mindspore::schema::Assign *>(value()) : nullptr;
  }
  const mindspore::schema::AssignAdd *value_as_AssignAdd() const {
    return value_type() == mindspore::schema::PrimitiveType_AssignAdd ? static_cast<const mindspore::schema::AssignAdd *>(value()) : nullptr;
  }
  const mindspore::schema::AudioSpectrogram *value_as_AudioSpectrogram() const {
    return value_type() == mindspore::schema::PrimitiveType_AudioSpectrogram ? static_cast<const mindspore::schema::AudioSpectrogram *>(value()) : nullptr;
  }
  const mindspore::schema::AvgPoolFusion *value_as_AvgPoolFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_AvgPoolFusion ? static_cast<const mindspore::schema::AvgPoolFusion *>(value()) : nullptr;
  }
  const mindspore::schema::AvgPoolGrad *value_as_AvgPoolGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_AvgPoolGrad ? static_cast<const mindspore::schema::AvgPoolGrad *>(value()) : nullptr;
  }
  const mindspore::schema::BatchNorm *value_as_BatchNorm() const {
    return value_type() == mindspore::schema::PrimitiveType_BatchNorm ? static_cast<const mindspore::schema::BatchNorm *>(value()) : nullptr;
  }
  const mindspore::schema::BatchNormGrad *value_as_BatchNormGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_BatchNormGrad ? static_cast<const mindspore::schema::BatchNormGrad *>(value()) : nullptr;
  }
  const mindspore::schema::BatchToSpace *value_as_BatchToSpace() const {
    return value_type() == mindspore::schema::PrimitiveType_BatchToSpace ? static_cast<const mindspore::schema::BatchToSpace *>(value()) : nullptr;
  }
  const mindspore::schema::BatchToSpaceND *value_as_BatchToSpaceND() const {
    return value_type() == mindspore::schema::PrimitiveType_BatchToSpaceND ? static_cast<const mindspore::schema::BatchToSpaceND *>(value()) : nullptr;
  }
  const mindspore::schema::BiasAdd *value_as_BiasAdd() const {
    return value_type() == mindspore::schema::PrimitiveType_BiasAdd ? static_cast<const mindspore::schema::BiasAdd *>(value()) : nullptr;
  }
  const mindspore::schema::BinaryCrossEntropy *value_as_BinaryCrossEntropy() const {
    return value_type() == mindspore::schema::PrimitiveType_BinaryCrossEntropy ? static_cast<const mindspore::schema::BinaryCrossEntropy *>(value()) : nullptr;
  }
  const mindspore::schema::BinaryCrossEntropyGrad *value_as_BinaryCrossEntropyGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_BinaryCrossEntropyGrad ? static_cast<const mindspore::schema::BinaryCrossEntropyGrad *>(value()) : nullptr;
  }
  const mindspore::schema::BiasAddGrad *value_as_BiasAddGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_BiasAddGrad ? static_cast<const mindspore::schema::BiasAddGrad *>(value()) : nullptr;
  }
  const mindspore::schema::BroadcastTo *value_as_BroadcastTo() const {
    return value_type() == mindspore::schema::PrimitiveType_BroadcastTo ? static_cast<const mindspore::schema::BroadcastTo *>(value()) : nullptr;
  }
  const mindspore::schema::Cast *value_as_Cast() const {
    return value_type() == mindspore::schema::PrimitiveType_Cast ? static_cast<const mindspore::schema::Cast *>(value()) : nullptr;
  }
  const mindspore::schema::Ceil *value_as_Ceil() const {
    return value_type() == mindspore::schema::PrimitiveType_Ceil ? static_cast<const mindspore::schema::Ceil *>(value()) : nullptr;
  }
  const mindspore::schema::Clip *value_as_Clip() const {
    return value_type() == mindspore::schema::PrimitiveType_Clip ? static_cast<const mindspore::schema::Clip *>(value()) : nullptr;
  }
  const mindspore::schema::Concat *value_as_Concat() const {
    return value_type() == mindspore::schema::PrimitiveType_Concat ? static_cast<const mindspore::schema::Concat *>(value()) : nullptr;
  }
  const mindspore::schema::Attention *value_as_Attention() const {
    return value_type() == mindspore::schema::PrimitiveType_Attention ? static_cast<const mindspore::schema::Attention *>(value()) : nullptr;
  }
  const mindspore::schema::Conv2DBackpropFilterFusion *value_as_Conv2DBackpropFilterFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_Conv2DBackpropFilterFusion ? static_cast<const mindspore::schema::Conv2DBackpropFilterFusion *>(value()) : nullptr;
  }
  const mindspore::schema::Conv2DBackpropInputFusion *value_as_Conv2DBackpropInputFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_Conv2DBackpropInputFusion ? static_cast<const mindspore::schema::Conv2DBackpropInputFusion *>(value()) : nullptr;
  }
  const mindspore::schema::Conv2DFusion *value_as_Conv2DFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_Conv2DFusion ? static_cast<const mindspore::schema::Conv2DFusion *>(value()) : nullptr;
  }
  const mindspore::schema::Conv2dTransposeFusion *value_as_Conv2dTransposeFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_Conv2dTransposeFusion ? static_cast<const mindspore::schema::Conv2dTransposeFusion *>(value()) : nullptr;
  }
  const mindspore::schema::Cos *value_as_Cos() const {
    return value_type() == mindspore::schema::PrimitiveType_Cos ? static_cast<const mindspore::schema::Cos *>(value()) : nullptr;
  }
  const mindspore::schema::ConstantOfShape *value_as_ConstantOfShape() const {
    return value_type() == mindspore::schema::PrimitiveType_ConstantOfShape ? static_cast<const mindspore::schema::ConstantOfShape *>(value()) : nullptr;
  }
  const mindspore::schema::Crop *value_as_Crop() const {
    return value_type() == mindspore::schema::PrimitiveType_Crop ? static_cast<const mindspore::schema::Crop *>(value()) : nullptr;
  }
  const mindspore::schema::CustomExtractFeatures *value_as_CustomExtractFeatures() const {
    return value_type() == mindspore::schema::PrimitiveType_CustomExtractFeatures ? static_cast<const mindspore::schema::CustomExtractFeatures *>(value()) : nullptr;
  }
  const mindspore::schema::CustomNormalize *value_as_CustomNormalize() const {
    return value_type() == mindspore::schema::PrimitiveType_CustomNormalize ? static_cast<const mindspore::schema::CustomNormalize *>(value()) : nullptr;
  }
  const mindspore::schema::CustomPredict *value_as_CustomPredict() const {
    return value_type() == mindspore::schema::PrimitiveType_CustomPredict ? static_cast<const mindspore::schema::CustomPredict *>(value()) : nullptr;
  }
  const mindspore::schema::DeConv2DGradFilter *value_as_DeConv2DGradFilter() const {
    return value_type() == mindspore::schema::PrimitiveType_DeConv2DGradFilter ? static_cast<const mindspore::schema::DeConv2DGradFilter *>(value()) : nullptr;
  }
  const mindspore::schema::Depend *value_as_Depend() const {
    return value_type() == mindspore::schema::PrimitiveType_Depend ? static_cast<const mindspore::schema::Depend *>(value()) : nullptr;
  }
  const mindspore::schema::DepthToSpace *value_as_DepthToSpace() const {
    return value_type() == mindspore::schema::PrimitiveType_DepthToSpace ? static_cast<const mindspore::schema::DepthToSpace *>(value()) : nullptr;
  }
  const mindspore::schema::DetectionPostProcess *value_as_DetectionPostProcess() const {
    return value_type() == mindspore::schema::PrimitiveType_DetectionPostProcess ? static_cast<const mindspore::schema::DetectionPostProcess *>(value()) : nullptr;
  }
  const mindspore::schema::DivFusion *value_as_DivFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_DivFusion ? static_cast<const mindspore::schema::DivFusion *>(value()) : nullptr;
  }
  const mindspore::schema::DivGrad *value_as_DivGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_DivGrad ? static_cast<const mindspore::schema::DivGrad *>(value()) : nullptr;
  }
  const mindspore::schema::Dropout *value_as_Dropout() const {
    return value_type() == mindspore::schema::PrimitiveType_Dropout ? static_cast<const mindspore::schema::Dropout *>(value()) : nullptr;
  }
  const mindspore::schema::DropoutGrad *value_as_DropoutGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_DropoutGrad ? static_cast<const mindspore::schema::DropoutGrad *>(value()) : nullptr;
  }
  const mindspore::schema::Elu *value_as_Elu() const {
    return value_type() == mindspore::schema::PrimitiveType_Elu ? static_cast<const mindspore::schema::Elu *>(value()) : nullptr;
  }
  const mindspore::schema::Eltwise *value_as_Eltwise() const {
    return value_type() == mindspore::schema::PrimitiveType_Eltwise ? static_cast<const mindspore::schema::Eltwise *>(value()) : nullptr;
  }
  const mindspore::schema::Equal *value_as_Equal() const {
    return value_type() == mindspore::schema::PrimitiveType_Equal ? static_cast<const mindspore::schema::Equal *>(value()) : nullptr;
  }
  const mindspore::schema::EmbeddingLookupFusion *value_as_EmbeddingLookupFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_EmbeddingLookupFusion ? static_cast<const mindspore::schema::EmbeddingLookupFusion *>(value()) : nullptr;
  }
  const mindspore::schema::ExpFusion *value_as_ExpFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_ExpFusion ? static_cast<const mindspore::schema::ExpFusion *>(value()) : nullptr;
  }
  const mindspore::schema::ExpandDims *value_as_ExpandDims() const {
    return value_type() == mindspore::schema::PrimitiveType_ExpandDims ? static_cast<const mindspore::schema::ExpandDims *>(value()) : nullptr;
  }
  const mindspore::schema::FakeQuantWithMinMaxVars *value_as_FakeQuantWithMinMaxVars() const {
    return value_type() == mindspore::schema::PrimitiveType_FakeQuantWithMinMaxVars ? static_cast<const mindspore::schema::FakeQuantWithMinMaxVars *>(value()) : nullptr;
  }
  const mindspore::schema::FakeQuantWithMinMaxVarsPerChannel *value_as_FakeQuantWithMinMaxVarsPerChannel() const {
    return value_type() == mindspore::schema::PrimitiveType_FakeQuantWithMinMaxVarsPerChannel ? static_cast<const mindspore::schema::FakeQuantWithMinMaxVarsPerChannel *>(value()) : nullptr;
  }
  const mindspore::schema::FftReal *value_as_FftReal() const {
    return value_type() == mindspore::schema::PrimitiveType_FftReal ? static_cast<const mindspore::schema::FftReal *>(value()) : nullptr;
  }
  const mindspore::schema::FftImag *value_as_FftImag() const {
    return value_type() == mindspore::schema::PrimitiveType_FftImag ? static_cast<const mindspore::schema::FftImag *>(value()) : nullptr;
  }
  const mindspore::schema::Flatten *value_as_Flatten() const {
    return value_type() == mindspore::schema::PrimitiveType_Flatten ? static_cast<const mindspore::schema::Flatten *>(value()) : nullptr;
  }
  const mindspore::schema::FlattenGrad *value_as_FlattenGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_FlattenGrad ? static_cast<const mindspore::schema::FlattenGrad *>(value()) : nullptr;
  }
  const mindspore::schema::Floor *value_as_Floor() const {
    return value_type() == mindspore::schema::PrimitiveType_Floor ? static_cast<const mindspore::schema::Floor *>(value()) : nullptr;
  }
  const mindspore::schema::FloorDiv *value_as_FloorDiv() const {
    return value_type() == mindspore::schema::PrimitiveType_FloorDiv ? static_cast<const mindspore::schema::FloorDiv *>(value()) : nullptr;
  }
  const mindspore::schema::FloorMod *value_as_FloorMod() const {
    return value_type() == mindspore::schema::PrimitiveType_FloorMod ? static_cast<const mindspore::schema::FloorMod *>(value()) : nullptr;
  }
  const mindspore::schema::Fill *value_as_Fill() const {
    return value_type() == mindspore::schema::PrimitiveType_Fill ? static_cast<const mindspore::schema::Fill *>(value()) : nullptr;
  }
  const mindspore::schema::FullConnection *value_as_FullConnection() const {
    return value_type() == mindspore::schema::PrimitiveType_FullConnection ? static_cast<const mindspore::schema::FullConnection *>(value()) : nullptr;
  }
  const mindspore::schema::FusedBatchNorm *value_as_FusedBatchNorm() const {
    return value_type() == mindspore::schema::PrimitiveType_FusedBatchNorm ? static_cast<const mindspore::schema::FusedBatchNorm *>(value()) : nullptr;
  }
  const mindspore::schema::Gather *value_as_Gather() const {
    return value_type() == mindspore::schema::PrimitiveType_Gather ? static_cast<const mindspore::schema::Gather *>(value()) : nullptr;
  }
  const mindspore::schema::GatherNd *value_as_GatherNd() const {
    return value_type() == mindspore::schema::PrimitiveType_GatherNd ? static_cast<const mindspore::schema::GatherNd *>(value()) : nullptr;
  }
  const mindspore::schema::Greater *value_as_Greater() const {
    return value_type() == mindspore::schema::PrimitiveType_Greater ? static_cast<const mindspore::schema::Greater *>(value()) : nullptr;
  }
  const mindspore::schema::GreaterEqual *value_as_GreaterEqual() const {
    return value_type() == mindspore::schema::PrimitiveType_GreaterEqual ? static_cast<const mindspore::schema::GreaterEqual *>(value()) : nullptr;
  }
  const mindspore::schema::HashtableLookup *value_as_HashtableLookup() const {
    return value_type() == mindspore::schema::PrimitiveType_HashtableLookup ? static_cast<const mindspore::schema::HashtableLookup *>(value()) : nullptr;
  }
  const mindspore::schema::InstanceNorm *value_as_InstanceNorm() const {
    return value_type() == mindspore::schema::PrimitiveType_InstanceNorm ? static_cast<const mindspore::schema::InstanceNorm *>(value()) : nullptr;
  }
  const mindspore::schema::LayerNormFusion *value_as_LayerNormFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_LayerNormFusion ? static_cast<const mindspore::schema::LayerNormFusion *>(value()) : nullptr;
  }
  const mindspore::schema::LeakyRelu *value_as_LeakyRelu() const {
    return value_type() == mindspore::schema::PrimitiveType_LeakyRelu ? static_cast<const mindspore::schema::LeakyRelu *>(value()) : nullptr;
  }
  const mindspore::schema::Less *value_as_Less() const {
    return value_type() == mindspore::schema::PrimitiveType_Less ? static_cast<const mindspore::schema::Less *>(value()) : nullptr;
  }
  const mindspore::schema::LessEqual *value_as_LessEqual() const {
    return value_type() == mindspore::schema::PrimitiveType_LessEqual ? static_cast<const mindspore::schema::LessEqual *>(value()) : nullptr;
  }
  const mindspore::schema::Log *value_as_Log() const {
    return value_type() == mindspore::schema::PrimitiveType_Log ? static_cast<const mindspore::schema::Log *>(value()) : nullptr;
  }
  const mindspore::schema::LogGrad *value_as_LogGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_LogGrad ? static_cast<const mindspore::schema::LogGrad *>(value()) : nullptr;
  }
  const mindspore::schema::LogicalAnd *value_as_LogicalAnd() const {
    return value_type() == mindspore::schema::PrimitiveType_LogicalAnd ? static_cast<const mindspore::schema::LogicalAnd *>(value()) : nullptr;
  }
  const mindspore::schema::LogicalNot *value_as_LogicalNot() const {
    return value_type() == mindspore::schema::PrimitiveType_LogicalNot ? static_cast<const mindspore::schema::LogicalNot *>(value()) : nullptr;
  }
  const mindspore::schema::LogicalOr *value_as_LogicalOr() const {
    return value_type() == mindspore::schema::PrimitiveType_LogicalOr ? static_cast<const mindspore::schema::LogicalOr *>(value()) : nullptr;
  }
  const mindspore::schema::LpNormalization *value_as_LpNormalization() const {
    return value_type() == mindspore::schema::PrimitiveType_LpNormalization ? static_cast<const mindspore::schema::LpNormalization *>(value()) : nullptr;
  }
  const mindspore::schema::LRN *value_as_LRN() const {
    return value_type() == mindspore::schema::PrimitiveType_LRN ? static_cast<const mindspore::schema::LRN *>(value()) : nullptr;
  }
  const mindspore::schema::LshProjection *value_as_LshProjection() const {
    return value_type() == mindspore::schema::PrimitiveType_LshProjection ? static_cast<const mindspore::schema::LshProjection *>(value()) : nullptr;
  }
  const mindspore::schema::LSTM *value_as_LSTM() const {
    return value_type() == mindspore::schema::PrimitiveType_LSTM ? static_cast<const mindspore::schema::LSTM *>(value()) : nullptr;
  }
  const mindspore::schema::L2NormalizeFusion *value_as_L2NormalizeFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_L2NormalizeFusion ? static_cast<const mindspore::schema::L2NormalizeFusion *>(value()) : nullptr;
  }
  const mindspore::schema::MatMulFusion *value_as_MatMulFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_MatMulFusion ? static_cast<const mindspore::schema::MatMulFusion *>(value()) : nullptr;
  }
  const mindspore::schema::Maximum *value_as_Maximum() const {
    return value_type() == mindspore::schema::PrimitiveType_Maximum ? static_cast<const mindspore::schema::Maximum *>(value()) : nullptr;
  }
  const mindspore::schema::MaximumGrad *value_as_MaximumGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_MaximumGrad ? static_cast<const mindspore::schema::MaximumGrad *>(value()) : nullptr;
  }
  const mindspore::schema::MaxPoolFusion *value_as_MaxPoolFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_MaxPoolFusion ? static_cast<const mindspore::schema::MaxPoolFusion *>(value()) : nullptr;
  }
  const mindspore::schema::MaxPoolGrad *value_as_MaxPoolGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_MaxPoolGrad ? static_cast<const mindspore::schema::MaxPoolGrad *>(value()) : nullptr;
  }
  const mindspore::schema::SwitchLayer *value_as_SwitchLayer() const {
    return value_type() == mindspore::schema::PrimitiveType_SwitchLayer ? static_cast<const mindspore::schema::SwitchLayer *>(value()) : nullptr;
  }
  const mindspore::schema::Mfcc *value_as_Mfcc() const {
    return value_type() == mindspore::schema::PrimitiveType_Mfcc ? static_cast<const mindspore::schema::Mfcc *>(value()) : nullptr;
  }
  const mindspore::schema::Minimum *value_as_Minimum() const {
    return value_type() == mindspore::schema::PrimitiveType_Minimum ? static_cast<const mindspore::schema::Minimum *>(value()) : nullptr;
  }
  const mindspore::schema::MinimumGrad *value_as_MinimumGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_MinimumGrad ? static_cast<const mindspore::schema::MinimumGrad *>(value()) : nullptr;
  }
  const mindspore::schema::Mod *value_as_Mod() const {
    return value_type() == mindspore::schema::PrimitiveType_Mod ? static_cast<const mindspore::schema::Mod *>(value()) : nullptr;
  }
  const mindspore::schema::MulFusion *value_as_MulFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_MulFusion ? static_cast<const mindspore::schema::MulFusion *>(value()) : nullptr;
  }
  const mindspore::schema::MulGrad *value_as_MulGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_MulGrad ? static_cast<const mindspore::schema::MulGrad *>(value()) : nullptr;
  }
  const mindspore::schema::Neg *value_as_Neg() const {
    return value_type() == mindspore::schema::PrimitiveType_Neg ? static_cast<const mindspore::schema::Neg *>(value()) : nullptr;
  }
  const mindspore::schema::NegGrad *value_as_NegGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_NegGrad ? static_cast<const mindspore::schema::NegGrad *>(value()) : nullptr;
  }
  const mindspore::schema::NotEqual *value_as_NotEqual() const {
    return value_type() == mindspore::schema::PrimitiveType_NotEqual ? static_cast<const mindspore::schema::NotEqual *>(value()) : nullptr;
  }
  const mindspore::schema::NonMaxSuppression *value_as_NonMaxSuppression() const {
    return value_type() == mindspore::schema::PrimitiveType_NonMaxSuppression ? static_cast<const mindspore::schema::NonMaxSuppression *>(value()) : nullptr;
  }
  const mindspore::schema::OneHot *value_as_OneHot() const {
    return value_type() == mindspore::schema::PrimitiveType_OneHot ? static_cast<const mindspore::schema::OneHot *>(value()) : nullptr;
  }
  const mindspore::schema::OnesLike *value_as_OnesLike() const {
    return value_type() == mindspore::schema::PrimitiveType_OnesLike ? static_cast<const mindspore::schema::OnesLike *>(value()) : nullptr;
  }
  const mindspore::schema::PadFusion *value_as_PadFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_PadFusion ? static_cast<const mindspore::schema::PadFusion *>(value()) : nullptr;
  }
  const mindspore::schema::PartialFusion *value_as_PartialFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_PartialFusion ? static_cast<const mindspore::schema::PartialFusion *>(value()) : nullptr;
  }
  const mindspore::schema::PowerGrad *value_as_PowerGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_PowerGrad ? static_cast<const mindspore::schema::PowerGrad *>(value()) : nullptr;
  }
  const mindspore::schema::PowFusion *value_as_PowFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_PowFusion ? static_cast<const mindspore::schema::PowFusion *>(value()) : nullptr;
  }
  const mindspore::schema::PriorBox *value_as_PriorBox() const {
    return value_type() == mindspore::schema::PrimitiveType_PriorBox ? static_cast<const mindspore::schema::PriorBox *>(value()) : nullptr;
  }
  const mindspore::schema::PReLUFusion *value_as_PReLUFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_PReLUFusion ? static_cast<const mindspore::schema::PReLUFusion *>(value()) : nullptr;
  }
  const mindspore::schema::QuantDTypeCast *value_as_QuantDTypeCast() const {
    return value_type() == mindspore::schema::PrimitiveType_QuantDTypeCast ? static_cast<const mindspore::schema::QuantDTypeCast *>(value()) : nullptr;
  }
  const mindspore::schema::Rank *value_as_Rank() const {
    return value_type() == mindspore::schema::PrimitiveType_Rank ? static_cast<const mindspore::schema::Rank *>(value()) : nullptr;
  }
  const mindspore::schema::Range *value_as_Range() const {
    return value_type() == mindspore::schema::PrimitiveType_Range ? static_cast<const mindspore::schema::Range *>(value()) : nullptr;
  }
  const mindspore::schema::Reciprocal *value_as_Reciprocal() const {
    return value_type() == mindspore::schema::PrimitiveType_Reciprocal ? static_cast<const mindspore::schema::Reciprocal *>(value()) : nullptr;
  }
  const mindspore::schema::RealDiv *value_as_RealDiv() const {
    return value_type() == mindspore::schema::PrimitiveType_RealDiv ? static_cast<const mindspore::schema::RealDiv *>(value()) : nullptr;
  }
  const mindspore::schema::ReduceFusion *value_as_ReduceFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_ReduceFusion ? static_cast<const mindspore::schema::ReduceFusion *>(value()) : nullptr;
  }
  const mindspore::schema::Reshape *value_as_Reshape() const {
    return value_type() == mindspore::schema::PrimitiveType_Reshape ? static_cast<const mindspore::schema::Reshape *>(value()) : nullptr;
  }
  const mindspore::schema::Resize *value_as_Resize() const {
    return value_type() == mindspore::schema::PrimitiveType_Resize ? static_cast<const mindspore::schema::Resize *>(value()) : nullptr;
  }
  const mindspore::schema::ReverseSequence *value_as_ReverseSequence() const {
    return value_type() == mindspore::schema::PrimitiveType_ReverseSequence ? static_cast<const mindspore::schema::ReverseSequence *>(value()) : nullptr;
  }
  const mindspore::schema::ReverseV2 *value_as_ReverseV2() const {
    return value_type() == mindspore::schema::PrimitiveType_ReverseV2 ? static_cast<const mindspore::schema::ReverseV2 *>(value()) : nullptr;
  }
  const mindspore::schema::Rfft *value_as_Rfft() const {
    return value_type() == mindspore::schema::PrimitiveType_Rfft ? static_cast<const mindspore::schema::Rfft *>(value()) : nullptr;
  }
  const mindspore::schema::ROIPooling *value_as_ROIPooling() const {
    return value_type() == mindspore::schema::PrimitiveType_ROIPooling ? static_cast<const mindspore::schema::ROIPooling *>(value()) : nullptr;
  }
  const mindspore::schema::Round *value_as_Round() const {
    return value_type() == mindspore::schema::PrimitiveType_Round ? static_cast<const mindspore::schema::Round *>(value()) : nullptr;
  }
  const mindspore::schema::Rsqrt *value_as_Rsqrt() const {
    return value_type() == mindspore::schema::PrimitiveType_Rsqrt ? static_cast<const mindspore::schema::Rsqrt *>(value()) : nullptr;
  }
  const mindspore::schema::ScaleFusion *value_as_ScaleFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_ScaleFusion ? static_cast<const mindspore::schema::ScaleFusion *>(value()) : nullptr;
  }
  const mindspore::schema::ScatterNd *value_as_ScatterNd() const {
    return value_type() == mindspore::schema::PrimitiveType_ScatterNd ? static_cast<const mindspore::schema::ScatterNd *>(value()) : nullptr;
  }
  const mindspore::schema::SGD *value_as_SGD() const {
    return value_type() == mindspore::schema::PrimitiveType_SGD ? static_cast<const mindspore::schema::SGD *>(value()) : nullptr;
  }
  const mindspore::schema::Shape *value_as_Shape() const {
    return value_type() == mindspore::schema::PrimitiveType_Shape ? static_cast<const mindspore::schema::Shape *>(value()) : nullptr;
  }
  const mindspore::schema::SigmoidCrossEntropyWithLogits *value_as_SigmoidCrossEntropyWithLogits() const {
    return value_type() == mindspore::schema::PrimitiveType_SigmoidCrossEntropyWithLogits ? static_cast<const mindspore::schema::SigmoidCrossEntropyWithLogits *>(value()) : nullptr;
  }
  const mindspore::schema::SigmoidCrossEntropyWithLogitsGrad *value_as_SigmoidCrossEntropyWithLogitsGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_SigmoidCrossEntropyWithLogitsGrad ? static_cast<const mindspore::schema::SigmoidCrossEntropyWithLogitsGrad *>(value()) : nullptr;
  }
  const mindspore::schema::Sin *value_as_Sin() const {
    return value_type() == mindspore::schema::PrimitiveType_Sin ? static_cast<const mindspore::schema::Sin *>(value()) : nullptr;
  }
  const mindspore::schema::SkipGram *value_as_SkipGram() const {
    return value_type() == mindspore::schema::PrimitiveType_SkipGram ? static_cast<const mindspore::schema::SkipGram *>(value()) : nullptr;
  }
  const mindspore::schema::SliceFusion *value_as_SliceFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_SliceFusion ? static_cast<const mindspore::schema::SliceFusion *>(value()) : nullptr;
  }
  const mindspore::schema::SmoothL1Loss *value_as_SmoothL1Loss() const {
    return value_type() == mindspore::schema::PrimitiveType_SmoothL1Loss ? static_cast<const mindspore::schema::SmoothL1Loss *>(value()) : nullptr;
  }
  const mindspore::schema::SmoothL1LossGrad *value_as_SmoothL1LossGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_SmoothL1LossGrad ? static_cast<const mindspore::schema::SmoothL1LossGrad *>(value()) : nullptr;
  }
  const mindspore::schema::Softmax *value_as_Softmax() const {
    return value_type() == mindspore::schema::PrimitiveType_Softmax ? static_cast<const mindspore::schema::Softmax *>(value()) : nullptr;
  }
  const mindspore::schema::SoftmaxCrossEntropyWithLogits *value_as_SoftmaxCrossEntropyWithLogits() const {
    return value_type() == mindspore::schema::PrimitiveType_SoftmaxCrossEntropyWithLogits ? static_cast<const mindspore::schema::SoftmaxCrossEntropyWithLogits *>(value()) : nullptr;
  }
  const mindspore::schema::SpaceToBatch *value_as_SpaceToBatch() const {
    return value_type() == mindspore::schema::PrimitiveType_SpaceToBatch ? static_cast<const mindspore::schema::SpaceToBatch *>(value()) : nullptr;
  }
  const mindspore::schema::SpaceToBatchND *value_as_SpaceToBatchND() const {
    return value_type() == mindspore::schema::PrimitiveType_SpaceToBatchND ? static_cast<const mindspore::schema::SpaceToBatchND *>(value()) : nullptr;
  }
  const mindspore::schema::SpaceToDepth *value_as_SpaceToDepth() const {
    return value_type() == mindspore::schema::PrimitiveType_SpaceToDepth ? static_cast<const mindspore::schema::SpaceToDepth *>(value()) : nullptr;
  }
  const mindspore::schema::SparseSoftmaxCrossEntropyWithLogits *value_as_SparseSoftmaxCrossEntropyWithLogits() const {
    return value_type() == mindspore::schema::PrimitiveType_SparseSoftmaxCrossEntropyWithLogits ? static_cast<const mindspore::schema::SparseSoftmaxCrossEntropyWithLogits *>(value()) : nullptr;
  }
  const mindspore::schema::SparseToDense *value_as_SparseToDense() const {
    return value_type() == mindspore::schema::PrimitiveType_SparseToDense ? static_cast<const mindspore::schema::SparseToDense *>(value()) : nullptr;
  }
  const mindspore::schema::Split *value_as_Split() const {
    return value_type() == mindspore::schema::PrimitiveType_Split ? static_cast<const mindspore::schema::Split *>(value()) : nullptr;
  }
  const mindspore::schema::Sqrt *value_as_Sqrt() const {
    return value_type() == mindspore::schema::PrimitiveType_Sqrt ? static_cast<const mindspore::schema::Sqrt *>(value()) : nullptr;
  }
  const mindspore::schema::Squeeze *value_as_Squeeze() const {
    return value_type() == mindspore::schema::PrimitiveType_Squeeze ? static_cast<const mindspore::schema::Squeeze *>(value()) : nullptr;
  }
  const mindspore::schema::Square *value_as_Square() const {
    return value_type() == mindspore::schema::PrimitiveType_Square ? static_cast<const mindspore::schema::Square *>(value()) : nullptr;
  }
  const mindspore::schema::SquaredDifference *value_as_SquaredDifference() const {
    return value_type() == mindspore::schema::PrimitiveType_SquaredDifference ? static_cast<const mindspore::schema::SquaredDifference *>(value()) : nullptr;
  }
  const mindspore::schema::Stack *value_as_Stack() const {
    return value_type() == mindspore::schema::PrimitiveType_Stack ? static_cast<const mindspore::schema::Stack *>(value()) : nullptr;
  }
  const mindspore::schema::StridedSlice *value_as_StridedSlice() const {
    return value_type() == mindspore::schema::PrimitiveType_StridedSlice ? static_cast<const mindspore::schema::StridedSlice *>(value()) : nullptr;
  }
  const mindspore::schema::SubFusion *value_as_SubFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_SubFusion ? static_cast<const mindspore::schema::SubFusion *>(value()) : nullptr;
  }
  const mindspore::schema::SubGrad *value_as_SubGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_SubGrad ? static_cast<const mindspore::schema::SubGrad *>(value()) : nullptr;
  }
  const mindspore::schema::Switch *value_as_Switch() const {
    return value_type() == mindspore::schema::PrimitiveType_Switch ? static_cast<const mindspore::schema::Switch *>(value()) : nullptr;
  }
  const mindspore::schema::TensorListFromTensor *value_as_TensorListFromTensor() const {
    return value_type() == mindspore::schema::PrimitiveType_TensorListFromTensor ? static_cast<const mindspore::schema::TensorListFromTensor *>(value()) : nullptr;
  }
  const mindspore::schema::TensorListGetItem *value_as_TensorListGetItem() const {
    return value_type() == mindspore::schema::PrimitiveType_TensorListGetItem ? static_cast<const mindspore::schema::TensorListGetItem *>(value()) : nullptr;
  }
  const mindspore::schema::TensorListReserve *value_as_TensorListReserve() const {
    return value_type() == mindspore::schema::PrimitiveType_TensorListReserve ? static_cast<const mindspore::schema::TensorListReserve *>(value()) : nullptr;
  }
  const mindspore::schema::TensorListSetItem *value_as_TensorListSetItem() const {
    return value_type() == mindspore::schema::PrimitiveType_TensorListSetItem ? static_cast<const mindspore::schema::TensorListSetItem *>(value()) : nullptr;
  }
  const mindspore::schema::TensorListStack *value_as_TensorListStack() const {
    return value_type() == mindspore::schema::PrimitiveType_TensorListStack ? static_cast<const mindspore::schema::TensorListStack *>(value()) : nullptr;
  }
  const mindspore::schema::TileFusion *value_as_TileFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_TileFusion ? static_cast<const mindspore::schema::TileFusion *>(value()) : nullptr;
  }
  const mindspore::schema::TopKFusion *value_as_TopKFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_TopKFusion ? static_cast<const mindspore::schema::TopKFusion *>(value()) : nullptr;
  }
  const mindspore::schema::Transpose *value_as_Transpose() const {
    return value_type() == mindspore::schema::PrimitiveType_Transpose ? static_cast<const mindspore::schema::Transpose *>(value()) : nullptr;
  }
  const mindspore::schema::Unique *value_as_Unique() const {
    return value_type() == mindspore::schema::PrimitiveType_Unique ? static_cast<const mindspore::schema::Unique *>(value()) : nullptr;
  }
  const mindspore::schema::UnsortedSegmentSum *value_as_UnsortedSegmentSum() const {
    return value_type() == mindspore::schema::PrimitiveType_UnsortedSegmentSum ? static_cast<const mindspore::schema::UnsortedSegmentSum *>(value()) : nullptr;
  }
  const mindspore::schema::Unsqueeze *value_as_Unsqueeze() const {
    return value_type() == mindspore::schema::PrimitiveType_Unsqueeze ? static_cast<const mindspore::schema::Unsqueeze *>(value()) : nullptr;
  }
  const mindspore::schema::Unstack *value_as_Unstack() const {
    return value_type() == mindspore::schema::PrimitiveType_Unstack ? static_cast<const mindspore::schema::Unstack *>(value()) : nullptr;
  }
  const mindspore::schema::LSTMGrad *value_as_LSTMGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_LSTMGrad ? static_cast<const mindspore::schema::LSTMGrad *>(value()) : nullptr;
  }
  const mindspore::schema::Where *value_as_Where() const {
    return value_type() == mindspore::schema::PrimitiveType_Where ? static_cast<const mindspore::schema::Where *>(value()) : nullptr;
  }
  const mindspore::schema::ZerosLike *value_as_ZerosLike() const {
    return value_type() == mindspore::schema::PrimitiveType_ZerosLike ? static_cast<const mindspore::schema::ZerosLike *>(value()) : nullptr;
  }
  const mindspore::schema::Select *value_as_Select() const {
    return value_type() == mindspore::schema::PrimitiveType_Select ? static_cast<const mindspore::schema::Select *>(value()) : nullptr;
  }
  const mindspore::schema::ScatterNdUpdate *value_as_ScatterNdUpdate() const {
    return value_type() == mindspore::schema::PrimitiveType_ScatterNdUpdate ? static_cast<const mindspore::schema::ScatterNdUpdate *>(value()) : nullptr;
  }
  const mindspore::schema::GRU *value_as_GRU() const {
    return value_type() == mindspore::schema::PrimitiveType_GRU ? static_cast<const mindspore::schema::GRU *>(value()) : nullptr;
  }
  const mindspore::schema::NonZero *value_as_NonZero() const {
    return value_type() == mindspore::schema::PrimitiveType_NonZero ? static_cast<const mindspore::schema::NonZero *>(value()) : nullptr;
  }
  const mindspore::schema::InvertPermutation *value_as_InvertPermutation() const {
    return value_type() == mindspore::schema::PrimitiveType_InvertPermutation ? static_cast<const mindspore::schema::InvertPermutation *>(value()) : nullptr;
  }
  const mindspore::schema::Size *value_as_Size() const {
    return value_type() == mindspore::schema::PrimitiveType_Size ? static_cast<const mindspore::schema::Size *>(value()) : nullptr;
  }
  const mindspore::schema::RandomStandardNormal *value_as_RandomStandardNormal() const {
    return value_type() == mindspore::schema::PrimitiveType_RandomStandardNormal ? static_cast<const mindspore::schema::RandomStandardNormal *>(value()) : nullptr;
  }
  const mindspore::schema::CropAndResize *value_as_CropAndResize() const {
    return value_type() == mindspore::schema::PrimitiveType_CropAndResize ? static_cast<const mindspore::schema::CropAndResize *>(value()) : nullptr;
  }
  const mindspore::schema::Erf *value_as_Erf() const {
    return value_type() == mindspore::schema::PrimitiveType_Erf ? static_cast<const mindspore::schema::Erf *>(value()) : nullptr;
  }
  const mindspore::schema::StridedSliceGrad *value_as_StridedSliceGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_StridedSliceGrad ? static_cast<const mindspore::schema::StridedSliceGrad *>(value()) : nullptr;
  }
  const mindspore::schema::IsFinite *value_as_IsFinite() const {
    return value_type() == mindspore::schema::PrimitiveType_IsFinite ? static_cast<const mindspore::schema::IsFinite *>(value()) : nullptr;
  }
  const mindspore::schema::LinSpace *value_as_LinSpace() const {
    return value_type() == mindspore::schema::PrimitiveType_LinSpace ? static_cast<const mindspore::schema::LinSpace *>(value()) : nullptr;
  }
  const mindspore::schema::UniformReal *value_as_UniformReal() const {
    return value_type() == mindspore::schema::PrimitiveType_UniformReal ? static_cast<const mindspore::schema::UniformReal *>(value()) : nullptr;
  }
  const mindspore::schema::AbsGrad *value_as_AbsGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_AbsGrad ? static_cast<const mindspore::schema::AbsGrad *>(value()) : nullptr;
  }
  const mindspore::schema::RsqrtGrad *value_as_RsqrtGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_RsqrtGrad ? static_cast<const mindspore::schema::RsqrtGrad *>(value()) : nullptr;
  }
  const mindspore::schema::SqrtGrad *value_as_SqrtGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_SqrtGrad ? static_cast<const mindspore::schema::SqrtGrad *>(value()) : nullptr;
  }
  const mindspore::schema::LayerNormGrad *value_as_LayerNormGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_LayerNormGrad ? static_cast<const mindspore::schema::LayerNormGrad *>(value()) : nullptr;
  }
  const mindspore::schema::ResizeGrad *value_as_ResizeGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_ResizeGrad ? static_cast<const mindspore::schema::ResizeGrad *>(value()) : nullptr;
  }
  const mindspore::schema::Splice *value_as_Splice() const {
    return value_type() == mindspore::schema::PrimitiveType_Splice ? static_cast<const mindspore::schema::Splice *>(value()) : nullptr;
  }
  const mindspore::schema::LogSoftmax *value_as_LogSoftmax() const {
    return value_type() == mindspore::schema::PrimitiveType_LogSoftmax ? static_cast<const mindspore::schema::LogSoftmax *>(value()) : nullptr;
  }
  const mindspore::schema::Call *value_as_Call() const {
    return value_type() == mindspore::schema::PrimitiveType_Call ? static_cast<const mindspore::schema::Call *>(value()) : nullptr;
  }
  const mindspore::schema::Custom *value_as_Custom() const {
    return value_type() == mindspore::schema::PrimitiveType_Custom ? static_cast<const mindspore::schema::Custom *>(value()) : nullptr;
  }
  const mindspore::schema::CumSum *value_as_CumSum() const {
    return value_type() == mindspore::schema::PrimitiveType_CumSum ? static_cast<const mindspore::schema::CumSum *>(value()) : nullptr;
  }
  const mindspore::schema::SplitWithOverlap *value_as_SplitWithOverlap() const {
    return value_type() == mindspore::schema::PrimitiveType_SplitWithOverlap ? static_cast<const mindspore::schema::SplitWithOverlap *>(value()) : nullptr;
  }
  const mindspore::schema::GenOP *value_as_GenOP() const {
    return value_type() == mindspore::schema::PrimitiveType_GenOP ? static_cast<const mindspore::schema::GenOP *>(value()) : nullptr;
  }
  const mindspore::schema::RaggedRange *value_as_RaggedRange() const {
    return value_type() == mindspore::schema::PrimitiveType_RaggedRange ? static_cast<const mindspore::schema::RaggedRange *>(value()) : nullptr;
  }
  const mindspore::schema::GLU *value_as_GLU() const {
    return value_type() == mindspore::schema::PrimitiveType_GLU ? static_cast<const mindspore::schema::GLU *>(value()) : nullptr;
  }
  const mindspore::schema::TensorArray *value_as_TensorArray() const {
    return value_type() == mindspore::schema::PrimitiveType_TensorArray ? static_cast<const mindspore::schema::TensorArray *>(value()) : nullptr;
  }
  const mindspore::schema::TensorArrayRead *value_as_TensorArrayRead() const {
    return value_type() == mindspore::schema::PrimitiveType_TensorArrayRead ? static_cast<const mindspore::schema::TensorArrayRead *>(value()) : nullptr;
  }
  const mindspore::schema::TensorArrayWrite *value_as_TensorArrayWrite() const {
    return value_type() == mindspore::schema::PrimitiveType_TensorArrayWrite ? static_cast<const mindspore::schema::TensorArrayWrite *>(value()) : nullptr;
  }
  const mindspore::schema::Affine *value_as_Affine() const {
    return value_type() == mindspore::schema::PrimitiveType_Affine ? static_cast<const mindspore::schema::Affine *>(value()) : nullptr;
  }
  const mindspore::schema::AllGather *value_as_AllGather() const {
    return value_type() == mindspore::schema::PrimitiveType_AllGather ? static_cast<const mindspore::schema::AllGather *>(value()) : nullptr;
  }
  const mindspore::schema::ReduceScatter *value_as_ReduceScatter() const {
    return value_type() == mindspore::schema::PrimitiveType_ReduceScatter ? static_cast<const mindspore::schema::ReduceScatter *>(value()) : nullptr;
  }
  const mindspore::schema::DynamicQuant *value_as_DynamicQuant() const {
    return value_type() == mindspore::schema::PrimitiveType_DynamicQuant ? static_cast<const mindspore::schema::DynamicQuant *>(value()) : nullptr;
  }
  const mindspore::schema::LSTMGradData *value_as_LSTMGradData() const {
    return value_type() == mindspore::schema::PrimitiveType_LSTMGradData ? static_cast<const mindspore::schema::LSTMGradData *>(value()) : nullptr;
  }
  const mindspore::schema::LSTMGradWeight *value_as_LSTMGradWeight() const {
    return value_type() == mindspore::schema::PrimitiveType_LSTMGradWeight ? static_cast<const mindspore::schema::LSTMGradWeight *>(value()) : nullptr;
  }
  const mindspore::schema::RandomNormal *value_as_RandomNormal() const {
    return value_type() == mindspore::schema::PrimitiveType_RandomNormal ? static_cast<const mindspore::schema::RandomNormal *>(value()) : nullptr;
  }
  const mindspore::schema::NLLLoss *value_as_NLLLoss() const {
    return value_type() == mindspore::schema::PrimitiveType_NLLLoss ? static_cast<const mindspore::schema::NLLLoss *>(value()) : nullptr;
  }
  const mindspore::schema::NLLLossGrad *value_as_NLLLossGrad() const {
    return value_type() == mindspore::schema::PrimitiveType_NLLLossGrad ? static_cast<const mindspore::schema::NLLLossGrad *>(value()) : nullptr;
  }
  const mindspore::schema::FormatTranspose *value_as_FormatTranspose() const {
    return value_type() == mindspore::schema::PrimitiveType_FormatTranspose ? static_cast<const mindspore::schema::FormatTranspose *>(value()) : nullptr;
  }
  const mindspore::schema::GatherD *value_as_GatherD() const {
    return value_type() == mindspore::schema::PrimitiveType_GatherD ? static_cast<const mindspore::schema::GatherD *>(value()) : nullptr;
  }
  const mindspore::schema::GroupNormFusion *value_as_GroupNormFusion() const {
    return value_type() == mindspore::schema::PrimitiveType_GroupNormFusion ? static_cast<const mindspore::schema::GroupNormFusion *>(value()) : nullptr;
  }
  const mindspore::schema::Log1p *value_as_Log1p() const {
    return value_type() == mindspore::schema::PrimitiveType_Log1p ? static_cast<const mindspore::schema::Log1p *>(value()) : nullptr;
  }
  const mindspore::schema::TensorScatterAdd *value_as_TensorScatterAdd() const {
    return value_type() == mindspore::schema::PrimitiveType_TensorScatterAdd ? static_cast<const mindspore::schema::TensorScatterAdd *>(value()) : nullptr;
  }
  const mindspore::schema::SparseFillEmptyRows *value_as_SparseFillEmptyRows() const {
    return value_type() == mindspore::schema::PrimitiveType_SparseFillEmptyRows ? static_cast<const mindspore::schema::SparseFillEmptyRows *>(value()) : nullptr;
  }
  const mindspore::schema::SparseReshape *value_as_SparseReshape() const {
    return value_type() == mindspore::schema::PrimitiveType_SparseReshape ? static_cast<const mindspore::schema::SparseReshape *>(value()) : nullptr;
  }
  const mindspore::schema::SparseSegmentSum *value_as_SparseSegmentSum() const {
    return value_type() == mindspore::schema::PrimitiveType_SparseSegmentSum ? static_cast<const mindspore::schema::SparseSegmentSum *>(value()) : nullptr;
  }
  const mindspore::schema::ScatterElements *value_as_ScatterElements() const {
    return value_type() == mindspore::schema::PrimitiveType_ScatterElements ? static_cast<const mindspore::schema::ScatterElements *>(value()) : nullptr;
  }
  const mindspore::schema::Triu *value_as_Triu() const {
    return value_type() == mindspore::schema::PrimitiveType_Triu ? static_cast<const mindspore::schema::Triu *>(value()) : nullptr;
  }
  const mindspore::schema::Tril *value_as_Tril() const {
    return value_type() == mindspore::schema::PrimitiveType_Tril ? static_cast<const mindspore::schema::Tril *>(value()) : nullptr;
  }
  const mindspore::schema::AdamWeightDecay *value_as_AdamWeightDecay() const {
    return value_type() == mindspore::schema::PrimitiveType_AdamWeightDecay ? static_cast<const mindspore::schema::AdamWeightDecay *>(value()) : nullptr;
  }
  const mindspore::schema::FillV2 *value_as_FillV2() const {
    return value_type() == mindspore::schema::PrimitiveType_FillV2 ? static_cast<const mindspore::schema::FillV2 *>(value()) : nullptr;
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<uint8_t>(verifier, VT_VALUE_TYPE) &&
           VerifyOffset(verifier, VT_VALUE) &&
           VerifyPrimitiveType(verifier, value(), value_type()) &&
           verifier.EndTable();
  }
};

template<> inline const mindspore::schema::Abs *Primitive::value_as<mindspore::schema::Abs>() const {
  return value_as_Abs();
}

template<> inline const mindspore::schema::Activation *Primitive::value_as<mindspore::schema::Activation>() const {
  return value_as_Activation();
}

template<> inline const mindspore::schema::ActivationGrad *Primitive::value_as<mindspore::schema::ActivationGrad>() const {
  return value_as_ActivationGrad();
}

template<> inline const mindspore::schema::Adam *Primitive::value_as<mindspore::schema::Adam>() const {
  return value_as_Adam();
}

template<> inline const mindspore::schema::AddFusion *Primitive::value_as<mindspore::schema::AddFusion>() const {
  return value_as_AddFusion();
}

template<> inline const mindspore::schema::AdderFusion *Primitive::value_as<mindspore::schema::AdderFusion>() const {
  return value_as_AdderFusion();
}

template<> inline const mindspore::schema::AddGrad *Primitive::value_as<mindspore::schema::AddGrad>() const {
  return value_as_AddGrad();
}

template<> inline const mindspore::schema::AddN *Primitive::value_as<mindspore::schema::AddN>() const {
  return value_as_AddN();
}

template<> inline const mindspore::schema::All *Primitive::value_as<mindspore::schema::All>() const {
  return value_as_All();
}

template<> inline const mindspore::schema::ApplyMomentum *Primitive::value_as<mindspore::schema::ApplyMomentum>() const {
  return value_as_ApplyMomentum();
}

template<> inline const mindspore::schema::ArgMaxFusion *Primitive::value_as<mindspore::schema::ArgMaxFusion>() const {
  return value_as_ArgMaxFusion();
}

template<> inline const mindspore::schema::ArgMinFusion *Primitive::value_as<mindspore::schema::ArgMinFusion>() const {
  return value_as_ArgMinFusion();
}

template<> inline const mindspore::schema::Assert *Primitive::value_as<mindspore::schema::Assert>() const {
  return value_as_Assert();
}

template<> inline const mindspore::schema::Assign *Primitive::value_as<mindspore::schema::Assign>() const {
  return value_as_Assign();
}

template<> inline const mindspore::schema::AssignAdd *Primitive::value_as<mindspore::schema::AssignAdd>() const {
  return value_as_AssignAdd();
}

template<> inline const mindspore::schema::AudioSpectrogram *Primitive::value_as<mindspore::schema::AudioSpectrogram>() const {
  return value_as_AudioSpectrogram();
}

template<> inline const mindspore::schema::AvgPoolFusion *Primitive::value_as<mindspore::schema::AvgPoolFusion>() const {
  return value_as_AvgPoolFusion();
}

template<> inline const mindspore::schema::AvgPoolGrad *Primitive::value_as<mindspore::schema::AvgPoolGrad>() const {
  return value_as_AvgPoolGrad();
}

template<> inline const mindspore::schema::BatchNorm *Primitive::value_as<mindspore::schema::BatchNorm>() const {
  return value_as_BatchNorm();
}

template<> inline const mindspore::schema::BatchNormGrad *Primitive::value_as<mindspore::schema::BatchNormGrad>() const {
  return value_as_BatchNormGrad();
}

template<> inline const mindspore::schema::BatchToSpace *Primitive::value_as<mindspore::schema::BatchToSpace>() const {
  return value_as_BatchToSpace();
}

template<> inline const mindspore::schema::BatchToSpaceND *Primitive::value_as<mindspore::schema::BatchToSpaceND>() const {
  return value_as_BatchToSpaceND();
}

template<> inline const mindspore::schema::BiasAdd *Primitive::value_as<mindspore::schema::BiasAdd>() const {
  return value_as_BiasAdd();
}

template<> inline const mindspore::schema::BinaryCrossEntropy *Primitive::value_as<mindspore::schema::BinaryCrossEntropy>() const {
  return value_as_BinaryCrossEntropy();
}

template<> inline const mindspore::schema::BinaryCrossEntropyGrad *Primitive::value_as<mindspore::schema::BinaryCrossEntropyGrad>() const {
  return value_as_BinaryCrossEntropyGrad();
}

template<> inline const mindspore::schema::BiasAddGrad *Primitive::value_as<mindspore::schema::BiasAddGrad>() const {
  return value_as_BiasAddGrad();
}

template<> inline const mindspore::schema::BroadcastTo *Primitive::value_as<mindspore::schema::BroadcastTo>() const {
  return value_as_BroadcastTo();
}

template<> inline const mindspore::schema::Cast *Primitive::value_as<mindspore::schema::Cast>() const {
  return value_as_Cast();
}

template<> inline const mindspore::schema::Ceil *Primitive::value_as<mindspore::schema::Ceil>() const {
  return value_as_Ceil();
}

template<> inline const mindspore::schema::Clip *Primitive::value_as<mindspore::schema::Clip>() const {
  return value_as_Clip();
}

template<> inline const mindspore::schema::Concat *Primitive::value_as<mindspore::schema::Concat>() const {
  return value_as_Concat();
}

template<> inline const mindspore::schema::Attention *Primitive::value_as<mindspore::schema::Attention>() const {
  return value_as_Attention();
}

template<> inline const mindspore::schema::Conv2DBackpropFilterFusion *Primitive::value_as<mindspore::schema::Conv2DBackpropFilterFusion>() const {
  return value_as_Conv2DBackpropFilterFusion();
}

template<> inline const mindspore::schema::Conv2DBackpropInputFusion *Primitive::value_as<mindspore::schema::Conv2DBackpropInputFusion>() const {
  return value_as_Conv2DBackpropInputFusion();
}

template<> inline const mindspore::schema::Conv2DFusion *Primitive::value_as<mindspore::schema::Conv2DFusion>() const {
  return value_as_Conv2DFusion();
}

template<> inline const mindspore::schema::Conv2dTransposeFusion *Primitive::value_as<mindspore::schema::Conv2dTransposeFusion>() const {
  return value_as_Conv2dTransposeFusion();
}

template<> inline const mindspore::schema::Cos *Primitive::value_as<mindspore::schema::Cos>() const {
  return value_as_Cos();
}

template<> inline const mindspore::schema::ConstantOfShape *Primitive::value_as<mindspore::schema::ConstantOfShape>() const {
  return value_as_ConstantOfShape();
}

template<> inline const mindspore::schema::Crop *Primitive::value_as<mindspore::schema::Crop>() const {
  return value_as_Crop();
}

template<> inline const mindspore::schema::CustomExtractFeatures *Primitive::value_as<mindspore::schema::CustomExtractFeatures>() const {
  return value_as_CustomExtractFeatures();
}

template<> inline const mindspore::schema::CustomNormalize *Primitive::value_as<mindspore::schema::CustomNormalize>() const {
  return value_as_CustomNormalize();
}

template<> inline const mindspore::schema::CustomPredict *Primitive::value_as<mindspore::schema::CustomPredict>() const {
  return value_as_CustomPredict();
}

template<> inline const mindspore::schema::DeConv2DGradFilter *Primitive::value_as<mindspore::schema::DeConv2DGradFilter>() const {
  return value_as_DeConv2DGradFilter();
}

template<> inline const mindspore::schema::Depend *Primitive::value_as<mindspore::schema::Depend>() const {
  return value_as_Depend();
}

template<> inline const mindspore::schema::DepthToSpace *Primitive::value_as<mindspore::schema::DepthToSpace>() const {
  return value_as_DepthToSpace();
}

template<> inline const mindspore::schema::DetectionPostProcess *Primitive::value_as<mindspore::schema::DetectionPostProcess>() const {
  return value_as_DetectionPostProcess();
}

template<> inline const mindspore::schema::DivFusion *Primitive::value_as<mindspore::schema::DivFusion>() const {
  return value_as_DivFusion();
}

template<> inline const mindspore::schema::DivGrad *Primitive::value_as<mindspore::schema::DivGrad>() const {
  return value_as_DivGrad();
}

template<> inline const mindspore::schema::Dropout *Primitive::value_as<mindspore::schema::Dropout>() const {
  return value_as_Dropout();
}

template<> inline const mindspore::schema::DropoutGrad *Primitive::value_as<mindspore::schema::DropoutGrad>() const {
  return value_as_DropoutGrad();
}

template<> inline const mindspore::schema::Elu *Primitive::value_as<mindspore::schema::Elu>() const {
  return value_as_Elu();
}

template<> inline const mindspore::schema::Eltwise *Primitive::value_as<mindspore::schema::Eltwise>() const {
  return value_as_Eltwise();
}

template<> inline const mindspore::schema::Equal *Primitive::value_as<mindspore::schema::Equal>() const {
  return value_as_Equal();
}

template<> inline const mindspore::schema::EmbeddingLookupFusion *Primitive::value_as<mindspore::schema::EmbeddingLookupFusion>() const {
  return value_as_EmbeddingLookupFusion();
}

template<> inline const mindspore::schema::ExpFusion *Primitive::value_as<mindspore::schema::ExpFusion>() const {
  return value_as_ExpFusion();
}

template<> inline const mindspore::schema::ExpandDims *Primitive::value_as<mindspore::schema::ExpandDims>() const {
  return value_as_ExpandDims();
}

template<> inline const mindspore::schema::FakeQuantWithMinMaxVars *Primitive::value_as<mindspore::schema::FakeQuantWithMinMaxVars>() const {
  return value_as_FakeQuantWithMinMaxVars();
}

template<> inline const mindspore::schema::FakeQuantWithMinMaxVarsPerChannel *Primitive::value_as<mindspore::schema::FakeQuantWithMinMaxVarsPerChannel>() const {
  return value_as_FakeQuantWithMinMaxVarsPerChannel();
}

template<> inline const mindspore::schema::FftReal *Primitive::value_as<mindspore::schema::FftReal>() const {
  return value_as_FftReal();
}

template<> inline const mindspore::schema::FftImag *Primitive::value_as<mindspore::schema::FftImag>() const {
  return value_as_FftImag();
}

template<> inline const mindspore::schema::Flatten *Primitive::value_as<mindspore::schema::Flatten>() const {
  return value_as_Flatten();
}

template<> inline const mindspore::schema::FlattenGrad *Primitive::value_as<mindspore::schema::FlattenGrad>() const {
  return value_as_FlattenGrad();
}

template<> inline const mindspore::schema::Floor *Primitive::value_as<mindspore::schema::Floor>() const {
  return value_as_Floor();
}

template<> inline const mindspore::schema::FloorDiv *Primitive::value_as<mindspore::schema::FloorDiv>() const {
  return value_as_FloorDiv();
}

template<> inline const mindspore::schema::FloorMod *Primitive::value_as<mindspore::schema::FloorMod>() const {
  return value_as_FloorMod();
}

template<> inline const mindspore::schema::Fill *Primitive::value_as<mindspore::schema::Fill>() const {
  return value_as_Fill();
}

template<> inline const mindspore::schema::FullConnection *Primitive::value_as<mindspore::schema::FullConnection>() const {
  return value_as_FullConnection();
}

template<> inline const mindspore::schema::FusedBatchNorm *Primitive::value_as<mindspore::schema::FusedBatchNorm>() const {
  return value_as_FusedBatchNorm();
}

template<> inline const mindspore::schema::Gather *Primitive::value_as<mindspore::schema::Gather>() const {
  return value_as_Gather();
}

template<> inline const mindspore::schema::GatherNd *Primitive::value_as<mindspore::schema::GatherNd>() const {
  return value_as_GatherNd();
}

template<> inline const mindspore::schema::Greater *Primitive::value_as<mindspore::schema::Greater>() const {
  return value_as_Greater();
}

template<> inline const mindspore::schema::GreaterEqual *Primitive::value_as<mindspore::schema::GreaterEqual>() const {
  return value_as_GreaterEqual();
}

template<> inline const mindspore::schema::HashtableLookup *Primitive::value_as<mindspore::schema::HashtableLookup>() const {
  return value_as_HashtableLookup();
}

template<> inline const mindspore::schema::InstanceNorm *Primitive::value_as<mindspore::schema::InstanceNorm>() const {
  return value_as_InstanceNorm();
}

template<> inline const mindspore::schema::LayerNormFusion *Primitive::value_as<mindspore::schema::LayerNormFusion>() const {
  return value_as_LayerNormFusion();
}

template<> inline const mindspore::schema::LeakyRelu *Primitive::value_as<mindspore::schema::LeakyRelu>() const {
  return value_as_LeakyRelu();
}

template<> inline const mindspore::schema::Less *Primitive::value_as<mindspore::schema::Less>() const {
  return value_as_Less();
}

template<> inline const mindspore::schema::LessEqual *Primitive::value_as<mindspore::schema::LessEqual>() const {
  return value_as_LessEqual();
}

template<> inline const mindspore::schema::Log *Primitive::value_as<mindspore::schema::Log>() const {
  return value_as_Log();
}

template<> inline const mindspore::schema::LogGrad *Primitive::value_as<mindspore::schema::LogGrad>() const {
  return value_as_LogGrad();
}

template<> inline const mindspore::schema::LogicalAnd *Primitive::value_as<mindspore::schema::LogicalAnd>() const {
  return value_as_LogicalAnd();
}

template<> inline const mindspore::schema::LogicalNot *Primitive::value_as<mindspore::schema::LogicalNot>() const {
  return value_as_LogicalNot();
}

template<> inline const mindspore::schema::LogicalOr *Primitive::value_as<mindspore::schema::LogicalOr>() const {
  return value_as_LogicalOr();
}

template<> inline const mindspore::schema::LpNormalization *Primitive::value_as<mindspore::schema::LpNormalization>() const {
  return value_as_LpNormalization();
}

template<> inline const mindspore::schema::LRN *Primitive::value_as<mindspore::schema::LRN>() const {
  return value_as_LRN();
}

template<> inline const mindspore::schema::LshProjection *Primitive::value_as<mindspore::schema::LshProjection>() const {
  return value_as_LshProjection();
}

template<> inline const mindspore::schema::LSTM *Primitive::value_as<mindspore::schema::LSTM>() const {
  return value_as_LSTM();
}

template<> inline const mindspore::schema::L2NormalizeFusion *Primitive::value_as<mindspore::schema::L2NormalizeFusion>() const {
  return value_as_L2NormalizeFusion();
}

template<> inline const mindspore::schema::MatMulFusion *Primitive::value_as<mindspore::schema::MatMulFusion>() const {
  return value_as_MatMulFusion();
}

template<> inline const mindspore::schema::Maximum *Primitive::value_as<mindspore::schema::Maximum>() const {
  return value_as_Maximum();
}

template<> inline const mindspore::schema::MaximumGrad *Primitive::value_as<mindspore::schema::MaximumGrad>() const {
  return value_as_MaximumGrad();
}

template<> inline const mindspore::schema::MaxPoolFusion *Primitive::value_as<mindspore::schema::MaxPoolFusion>() const {
  return value_as_MaxPoolFusion();
}

template<> inline const mindspore::schema::MaxPoolGrad *Primitive::value_as<mindspore::schema::MaxPoolGrad>() const {
  return value_as_MaxPoolGrad();
}

template<> inline const mindspore::schema::SwitchLayer *Primitive::value_as<mindspore::schema::SwitchLayer>() const {
  return value_as_SwitchLayer();
}

template<> inline const mindspore::schema::Mfcc *Primitive::value_as<mindspore::schema::Mfcc>() const {
  return value_as_Mfcc();
}

template<> inline const mindspore::schema::Minimum *Primitive::value_as<mindspore::schema::Minimum>() const {
  return value_as_Minimum();
}

template<> inline const mindspore::schema::MinimumGrad *Primitive::value_as<mindspore::schema::MinimumGrad>() const {
  return value_as_MinimumGrad();
}

template<> inline const mindspore::schema::Mod *Primitive::value_as<mindspore::schema::Mod>() const {
  return value_as_Mod();
}

template<> inline const mindspore::schema::MulFusion *Primitive::value_as<mindspore::schema::MulFusion>() const {
  return value_as_MulFusion();
}

template<> inline const mindspore::schema::MulGrad *Primitive::value_as<mindspore::schema::MulGrad>() const {
  return value_as_MulGrad();
}

template<> inline const mindspore::schema::Neg *Primitive::value_as<mindspore::schema::Neg>() const {
  return value_as_Neg();
}

template<> inline const mindspore::schema::NegGrad *Primitive::value_as<mindspore::schema::NegGrad>() const {
  return value_as_NegGrad();
}

template<> inline const mindspore::schema::NotEqual *Primitive::value_as<mindspore::schema::NotEqual>() const {
  return value_as_NotEqual();
}

template<> inline const mindspore::schema::NonMaxSuppression *Primitive::value_as<mindspore::schema::NonMaxSuppression>() const {
  return value_as_NonMaxSuppression();
}

template<> inline const mindspore::schema::OneHot *Primitive::value_as<mindspore::schema::OneHot>() const {
  return value_as_OneHot();
}

template<> inline const mindspore::schema::OnesLike *Primitive::value_as<mindspore::schema::OnesLike>() const {
  return value_as_OnesLike();
}

template<> inline const mindspore::schema::PadFusion *Primitive::value_as<mindspore::schema::PadFusion>() const {
  return value_as_PadFusion();
}

template<> inline const mindspore::schema::PartialFusion *Primitive::value_as<mindspore::schema::PartialFusion>() const {
  return value_as_PartialFusion();
}

template<> inline const mindspore::schema::PowerGrad *Primitive::value_as<mindspore::schema::PowerGrad>() const {
  return value_as_PowerGrad();
}

template<> inline const mindspore::schema::PowFusion *Primitive::value_as<mindspore::schema::PowFusion>() const {
  return value_as_PowFusion();
}

template<> inline const mindspore::schema::PriorBox *Primitive::value_as<mindspore::schema::PriorBox>() const {
  return value_as_PriorBox();
}

template<> inline const mindspore::schema::PReLUFusion *Primitive::value_as<mindspore::schema::PReLUFusion>() const {
  return value_as_PReLUFusion();
}

template<> inline const mindspore::schema::QuantDTypeCast *Primitive::value_as<mindspore::schema::QuantDTypeCast>() const {
  return value_as_QuantDTypeCast();
}

template<> inline const mindspore::schema::Rank *Primitive::value_as<mindspore::schema::Rank>() const {
  return value_as_Rank();
}

template<> inline const mindspore::schema::Range *Primitive::value_as<mindspore::schema::Range>() const {
  return value_as_Range();
}

template<> inline const mindspore::schema::Reciprocal *Primitive::value_as<mindspore::schema::Reciprocal>() const {
  return value_as_Reciprocal();
}

template<> inline const mindspore::schema::RealDiv *Primitive::value_as<mindspore::schema::RealDiv>() const {
  return value_as_RealDiv();
}

template<> inline const mindspore::schema::ReduceFusion *Primitive::value_as<mindspore::schema::ReduceFusion>() const {
  return value_as_ReduceFusion();
}

template<> inline const mindspore::schema::Reshape *Primitive::value_as<mindspore::schema::Reshape>() const {
  return value_as_Reshape();
}

template<> inline const mindspore::schema::Resize *Primitive::value_as<mindspore::schema::Resize>() const {
  return value_as_Resize();
}

template<> inline const mindspore::schema::ReverseSequence *Primitive::value_as<mindspore::schema::ReverseSequence>() const {
  return value_as_ReverseSequence();
}

template<> inline const mindspore::schema::ReverseV2 *Primitive::value_as<mindspore::schema::ReverseV2>() const {
  return value_as_ReverseV2();
}

template<> inline const mindspore::schema::Rfft *Primitive::value_as<mindspore::schema::Rfft>() const {
  return value_as_Rfft();
}

template<> inline const mindspore::schema::ROIPooling *Primitive::value_as<mindspore::schema::ROIPooling>() const {
  return value_as_ROIPooling();
}

template<> inline const mindspore::schema::Round *Primitive::value_as<mindspore::schema::Round>() const {
  return value_as_Round();
}

template<> inline const mindspore::schema::Rsqrt *Primitive::value_as<mindspore::schema::Rsqrt>() const {
  return value_as_Rsqrt();
}

template<> inline const mindspore::schema::ScaleFusion *Primitive::value_as<mindspore::schema::ScaleFusion>() const {
  return value_as_ScaleFusion();
}

template<> inline const mindspore::schema::ScatterNd *Primitive::value_as<mindspore::schema::ScatterNd>() const {
  return value_as_ScatterNd();
}

template<> inline const mindspore::schema::SGD *Primitive::value_as<mindspore::schema::SGD>() const {
  return value_as_SGD();
}

template<> inline const mindspore::schema::Shape *Primitive::value_as<mindspore::schema::Shape>() const {
  return value_as_Shape();
}

template<> inline const mindspore::schema::SigmoidCrossEntropyWithLogits *Primitive::value_as<mindspore::schema::SigmoidCrossEntropyWithLogits>() const {
  return value_as_SigmoidCrossEntropyWithLogits();
}

template<> inline const mindspore::schema::SigmoidCrossEntropyWithLogitsGrad *Primitive::value_as<mindspore::schema::SigmoidCrossEntropyWithLogitsGrad>() const {
  return value_as_SigmoidCrossEntropyWithLogitsGrad();
}

template<> inline const mindspore::schema::Sin *Primitive::value_as<mindspore::schema::Sin>() const {
  return value_as_Sin();
}

template<> inline const mindspore::schema::SkipGram *Primitive::value_as<mindspore::schema::SkipGram>() const {
  return value_as_SkipGram();
}

template<> inline const mindspore::schema::SliceFusion *Primitive::value_as<mindspore::schema::SliceFusion>() const {
  return value_as_SliceFusion();
}

template<> inline const mindspore::schema::SmoothL1Loss *Primitive::value_as<mindspore::schema::SmoothL1Loss>() const {
  return value_as_SmoothL1Loss();
}

template<> inline const mindspore::schema::SmoothL1LossGrad *Primitive::value_as<mindspore::schema::SmoothL1LossGrad>() const {
  return value_as_SmoothL1LossGrad();
}

template<> inline const mindspore::schema::Softmax *Primitive::value_as<mindspore::schema::Softmax>() const {
  return value_as_Softmax();
}

template<> inline const mindspore::schema::SoftmaxCrossEntropyWithLogits *Primitive::value_as<mindspore::schema::SoftmaxCrossEntropyWithLogits>() const {
  return value_as_SoftmaxCrossEntropyWithLogits();
}

template<> inline const mindspore::schema::SpaceToBatch *Primitive::value_as<mindspore::schema::SpaceToBatch>() const {
  return value_as_SpaceToBatch();
}

template<> inline const mindspore::schema::SpaceToBatchND *Primitive::value_as<mindspore::schema::SpaceToBatchND>() const {
  return value_as_SpaceToBatchND();
}

template<> inline const mindspore::schema::SpaceToDepth *Primitive::value_as<mindspore::schema::SpaceToDepth>() const {
  return value_as_SpaceToDepth();
}

template<> inline const mindspore::schema::SparseSoftmaxCrossEntropyWithLogits *Primitive::value_as<mindspore::schema::SparseSoftmaxCrossEntropyWithLogits>() const {
  return value_as_SparseSoftmaxCrossEntropyWithLogits();
}

template<> inline const mindspore::schema::SparseToDense *Primitive::value_as<mindspore::schema::SparseToDense>() const {
  return value_as_SparseToDense();
}

template<> inline const mindspore::schema::Split *Primitive::value_as<mindspore::schema::Split>() const {
  return value_as_Split();
}

template<> inline const mindspore::schema::Sqrt *Primitive::value_as<mindspore::schema::Sqrt>() const {
  return value_as_Sqrt();
}

template<> inline const mindspore::schema::Squeeze *Primitive::value_as<mindspore::schema::Squeeze>() const {
  return value_as_Squeeze();
}

template<> inline const mindspore::schema::Square *Primitive::value_as<mindspore::schema::Square>() const {
  return value_as_Square();
}

template<> inline const mindspore::schema::SquaredDifference *Primitive::value_as<mindspore::schema::SquaredDifference>() const {
  return value_as_SquaredDifference();
}

template<> inline const mindspore::schema::Stack *Primitive::value_as<mindspore::schema::Stack>() const {
  return value_as_Stack();
}

template<> inline const mindspore::schema::StridedSlice *Primitive::value_as<mindspore::schema::StridedSlice>() const {
  return value_as_StridedSlice();
}

template<> inline const mindspore::schema::SubFusion *Primitive::value_as<mindspore::schema::SubFusion>() const {
  return value_as_SubFusion();
}

template<> inline const mindspore::schema::SubGrad *Primitive::value_as<mindspore::schema::SubGrad>() const {
  return value_as_SubGrad();
}

template<> inline const mindspore::schema::Switch *Primitive::value_as<mindspore::schema::Switch>() const {
  return value_as_Switch();
}

template<> inline const mindspore::schema::TensorListFromTensor *Primitive::value_as<mindspore::schema::TensorListFromTensor>() const {
  return value_as_TensorListFromTensor();
}

template<> inline const mindspore::schema::TensorListGetItem *Primitive::value_as<mindspore::schema::TensorListGetItem>() const {
  return value_as_TensorListGetItem();
}

template<> inline const mindspore::schema::TensorListReserve *Primitive::value_as<mindspore::schema::TensorListReserve>() const {
  return value_as_TensorListReserve();
}

template<> inline const mindspore::schema::TensorListSetItem *Primitive::value_as<mindspore::schema::TensorListSetItem>() const {
  return value_as_TensorListSetItem();
}

template<> inline const mindspore::schema::TensorListStack *Primitive::value_as<mindspore::schema::TensorListStack>() const {
  return value_as_TensorListStack();
}

template<> inline const mindspore::schema::TileFusion *Primitive::value_as<mindspore::schema::TileFusion>() const {
  return value_as_TileFusion();
}

template<> inline const mindspore::schema::TopKFusion *Primitive::value_as<mindspore::schema::TopKFusion>() const {
  return value_as_TopKFusion();
}

template<> inline const mindspore::schema::Transpose *Primitive::value_as<mindspore::schema::Transpose>() const {
  return value_as_Transpose();
}

template<> inline const mindspore::schema::Unique *Primitive::value_as<mindspore::schema::Unique>() const {
  return value_as_Unique();
}

template<> inline const mindspore::schema::UnsortedSegmentSum *Primitive::value_as<mindspore::schema::UnsortedSegmentSum>() const {
  return value_as_UnsortedSegmentSum();
}

template<> inline const mindspore::schema::Unsqueeze *Primitive::value_as<mindspore::schema::Unsqueeze>() const {
  return value_as_Unsqueeze();
}

template<> inline const mindspore::schema::Unstack *Primitive::value_as<mindspore::schema::Unstack>() const {
  return value_as_Unstack();
}

template<> inline const mindspore::schema::LSTMGrad *Primitive::value_as<mindspore::schema::LSTMGrad>() const {
  return value_as_LSTMGrad();
}

template<> inline const mindspore::schema::Where *Primitive::value_as<mindspore::schema::Where>() const {
  return value_as_Where();
}

template<> inline const mindspore::schema::ZerosLike *Primitive::value_as<mindspore::schema::ZerosLike>() const {
  return value_as_ZerosLike();
}

template<> inline const mindspore::schema::Select *Primitive::value_as<mindspore::schema::Select>() const {
  return value_as_Select();
}

template<> inline const mindspore::schema::ScatterNdUpdate *Primitive::value_as<mindspore::schema::ScatterNdUpdate>() const {
  return value_as_ScatterNdUpdate();
}

template<> inline const mindspore::schema::GRU *Primitive::value_as<mindspore::schema::GRU>() const {
  return value_as_GRU();
}

template<> inline const mindspore::schema::NonZero *Primitive::value_as<mindspore::schema::NonZero>() const {
  return value_as_NonZero();
}

template<> inline const mindspore::schema::InvertPermutation *Primitive::value_as<mindspore::schema::InvertPermutation>() const {
  return value_as_InvertPermutation();
}

template<> inline const mindspore::schema::Size *Primitive::value_as<mindspore::schema::Size>() const {
  return value_as_Size();
}

template<> inline const mindspore::schema::RandomStandardNormal *Primitive::value_as<mindspore::schema::RandomStandardNormal>() const {
  return value_as_RandomStandardNormal();
}

template<> inline const mindspore::schema::CropAndResize *Primitive::value_as<mindspore::schema::CropAndResize>() const {
  return value_as_CropAndResize();
}

template<> inline const mindspore::schema::Erf *Primitive::value_as<mindspore::schema::Erf>() const {
  return value_as_Erf();
}

template<> inline const mindspore::schema::StridedSliceGrad *Primitive::value_as<mindspore::schema::StridedSliceGrad>() const {
  return value_as_StridedSliceGrad();
}

template<> inline const mindspore::schema::IsFinite *Primitive::value_as<mindspore::schema::IsFinite>() const {
  return value_as_IsFinite();
}

template<> inline const mindspore::schema::LinSpace *Primitive::value_as<mindspore::schema::LinSpace>() const {
  return value_as_LinSpace();
}

template<> inline const mindspore::schema::UniformReal *Primitive::value_as<mindspore::schema::UniformReal>() const {
  return value_as_UniformReal();
}

template<> inline const mindspore::schema::AbsGrad *Primitive::value_as<mindspore::schema::AbsGrad>() const {
  return value_as_AbsGrad();
}

template<> inline const mindspore::schema::RsqrtGrad *Primitive::value_as<mindspore::schema::RsqrtGrad>() const {
  return value_as_RsqrtGrad();
}

template<> inline const mindspore::schema::SqrtGrad *Primitive::value_as<mindspore::schema::SqrtGrad>() const {
  return value_as_SqrtGrad();
}

template<> inline const mindspore::schema::LayerNormGrad *Primitive::value_as<mindspore::schema::LayerNormGrad>() const {
  return value_as_LayerNormGrad();
}

template<> inline const mindspore::schema::ResizeGrad *Primitive::value_as<mindspore::schema::ResizeGrad>() const {
  return value_as_ResizeGrad();
}

template<> inline const mindspore::schema::Splice *Primitive::value_as<mindspore::schema::Splice>() const {
  return value_as_Splice();
}

template<> inline const mindspore::schema::LogSoftmax *Primitive::value_as<mindspore::schema::LogSoftmax>() const {
  return value_as_LogSoftmax();
}

template<> inline const mindspore::schema::Call *Primitive::value_as<mindspore::schema::Call>() const {
  return value_as_Call();
}

template<> inline const mindspore::schema::Custom *Primitive::value_as<mindspore::schema::Custom>() const {
  return value_as_Custom();
}

template<> inline const mindspore::schema::CumSum *Primitive::value_as<mindspore::schema::CumSum>() const {
  return value_as_CumSum();
}

template<> inline const mindspore::schema::SplitWithOverlap *Primitive::value_as<mindspore::schema::SplitWithOverlap>() const {
  return value_as_SplitWithOverlap();
}

template<> inline const mindspore::schema::GenOP *Primitive::value_as<mindspore::schema::GenOP>() const {
  return value_as_GenOP();
}

template<> inline const mindspore::schema::RaggedRange *Primitive::value_as<mindspore::schema::RaggedRange>() const {
  return value_as_RaggedRange();
}

template<> inline const mindspore::schema::GLU *Primitive::value_as<mindspore::schema::GLU>() const {
  return value_as_GLU();
}

template<> inline const mindspore::schema::TensorArray *Primitive::value_as<mindspore::schema::TensorArray>() const {
  return value_as_TensorArray();
}

template<> inline const mindspore::schema::TensorArrayRead *Primitive::value_as<mindspore::schema::TensorArrayRead>() const {
  return value_as_TensorArrayRead();
}

template<> inline const mindspore::schema::TensorArrayWrite *Primitive::value_as<mindspore::schema::TensorArrayWrite>() const {
  return value_as_TensorArrayWrite();
}

template<> inline const mindspore::schema::Affine *Primitive::value_as<mindspore::schema::Affine>() const {
  return value_as_Affine();
}

template<> inline const mindspore::schema::AllGather *Primitive::value_as<mindspore::schema::AllGather>() const {
  return value_as_AllGather();
}

template<> inline const mindspore::schema::ReduceScatter *Primitive::value_as<mindspore::schema::ReduceScatter>() const {
  return value_as_ReduceScatter();
}

template<> inline const mindspore::schema::DynamicQuant *Primitive::value_as<mindspore::schema::DynamicQuant>() const {
  return value_as_DynamicQuant();
}

template<> inline const mindspore::schema::LSTMGradData *Primitive::value_as<mindspore::schema::LSTMGradData>() const {
  return value_as_LSTMGradData();
}

template<> inline const mindspore::schema::LSTMGradWeight *Primitive::value_as<mindspore::schema::LSTMGradWeight>() const {
  return value_as_LSTMGradWeight();
}

template<> inline const mindspore::schema::RandomNormal *Primitive::value_as<mindspore::schema::RandomNormal>() const {
  return value_as_RandomNormal();
}

template<> inline const mindspore::schema::NLLLoss *Primitive::value_as<mindspore::schema::NLLLoss>() const {
  return value_as_NLLLoss();
}

template<> inline const mindspore::schema::NLLLossGrad *Primitive::value_as<mindspore::schema::NLLLossGrad>() const {
  return value_as_NLLLossGrad();
}

template<> inline const mindspore::schema::FormatTranspose *Primitive::value_as<mindspore::schema::FormatTranspose>() const {
  return value_as_FormatTranspose();
}

template<> inline const mindspore::schema::GatherD *Primitive::value_as<mindspore::schema::GatherD>() const {
  return value_as_GatherD();
}

template<> inline const mindspore::schema::GroupNormFusion *Primitive::value_as<mindspore::schema::GroupNormFusion>() const {
  return value_as_GroupNormFusion();
}

template<> inline const mindspore::schema::Log1p *Primitive::value_as<mindspore::schema::Log1p>() const {
  return value_as_Log1p();
}

template<> inline const mindspore::schema::TensorScatterAdd *Primitive::value_as<mindspore::schema::TensorScatterAdd>() const {
  return value_as_TensorScatterAdd();
}

template<> inline const mindspore::schema::SparseFillEmptyRows *Primitive::value_as<mindspore::schema::SparseFillEmptyRows>() const {
  return value_as_SparseFillEmptyRows();
}

template<> inline const mindspore::schema::SparseReshape *Primitive::value_as<mindspore::schema::SparseReshape>() const {
  return value_as_SparseReshape();
}

template<> inline const mindspore::schema::SparseSegmentSum *Primitive::value_as<mindspore::schema::SparseSegmentSum>() const {
  return value_as_SparseSegmentSum();
}

template<> inline const mindspore::schema::ScatterElements *Primitive::value_as<mindspore::schema::ScatterElements>() const {
  return value_as_ScatterElements();
}

template<> inline const mindspore::schema::Triu *Primitive::value_as<mindspore::schema::Triu>() const {
  return value_as_Triu();
}

template<> inline const mindspore::schema::Tril *Primitive::value_as<mindspore::schema::Tril>() const {
  return value_as_Tril();
}

template<> inline const mindspore::schema::AdamWeightDecay *Primitive::value_as<mindspore::schema::AdamWeightDecay>() const {
  return value_as_AdamWeightDecay();
}

template<> inline const mindspore::schema::FillV2 *Primitive::value_as<mindspore::schema::FillV2>() const {
  return value_as_FillV2();
}

struct PrimitiveBuilder {
  typedef Primitive Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_value_type(mindspore::schema::PrimitiveType value_type) {
    fbb_.AddElement<uint8_t>(Primitive::VT_VALUE_TYPE, static_cast<uint8_t>(value_type), 0);
  }
  void add_value(flatbuffers::Offset<void> value) {
    fbb_.AddOffset(Primitive::VT_VALUE, value);
  }
  explicit PrimitiveBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<Primitive> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<Primitive>(end);
    return o;
  }
};

inline flatbuffers::Offset<Primitive> CreatePrimitive(
    flatbuffers::FlatBufferBuilder &_fbb,
    mindspore::schema::PrimitiveType value_type = mindspore::schema::PrimitiveType_NONE,
    flatbuffers::Offset<void> value = 0) {
  PrimitiveBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_value_type(value_type);
  return builder_.Finish();
}

struct CNode FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef CNodeBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_NAME = 4,
    VT_PRIMITIVE = 8,
    VT_INPUTINDEX = 10,
    VT_OUTPUTINDEX = 12,
    VT_QUANTTYPE = 14,
    VT_DEVICETYPE = 16
  };
  const flatbuffers::String *name() const {
    return GetPointer<const flatbuffers::String *>(VT_NAME);
  }
  const mindspore::schema::Primitive *primitive() const {
    return GetPointer<const mindspore::schema::Primitive *>(VT_PRIMITIVE);
  }
  const flatbuffers::Vector<uint32_t> *inputIndex() const {
    return GetPointer<const flatbuffers::Vector<uint32_t> *>(VT_INPUTINDEX);
  }
  const flatbuffers::Vector<uint32_t> *outputIndex() const {
    return GetPointer<const flatbuffers::Vector<uint32_t> *>(VT_OUTPUTINDEX);
  }
  mindspore::schema::QuantType quantType() const {
    return static_cast<mindspore::schema::QuantType>(GetField<int32_t>(VT_QUANTTYPE, 0));
  }
  int32_t deviceType() const {
    return GetField<int32_t>(VT_DEVICETYPE, -1);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyOffset(verifier, VT_PRIMITIVE) &&
           verifier.VerifyTable(primitive()) &&
           VerifyOffset(verifier, VT_INPUTINDEX) &&
           verifier.VerifyVector(inputIndex()) &&
           VerifyOffset(verifier, VT_OUTPUTINDEX) &&
           verifier.VerifyVector(outputIndex()) &&
           VerifyField<int32_t>(verifier, VT_QUANTTYPE) &&
           VerifyField<int32_t>(verifier, VT_DEVICETYPE) &&
           verifier.EndTable();
  }
};

struct CNodeBuilder {
  typedef CNode Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_name(flatbuffers::Offset<flatbuffers::String> name) {
    fbb_.AddOffset(CNode::VT_NAME, name);
  }
  void add_primitive(flatbuffers::Offset<mindspore::schema::Primitive> primitive) {
    fbb_.AddOffset(CNode::VT_PRIMITIVE, primitive);
  }
  void add_inputIndex(flatbuffers::Offset<flatbuffers::Vector<uint32_t>> inputIndex) {
    fbb_.AddOffset(CNode::VT_INPUTINDEX, inputIndex);
  }
  void add_outputIndex(flatbuffers::Offset<flatbuffers::Vector<uint32_t>> outputIndex) {
    fbb_.AddOffset(CNode::VT_OUTPUTINDEX, outputIndex);
  }
  void add_quantType(mindspore::schema::QuantType quantType) {
    fbb_.AddElement<int32_t>(CNode::VT_QUANTTYPE, static_cast<int32_t>(quantType), 0);
  }
  void add_deviceType(int32_t deviceType) {
    fbb_.AddElement<int32_t>(CNode::VT_DEVICETYPE, deviceType, -1);
  }
  explicit CNodeBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<CNode> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<CNode>(end);
    return o;
  }
};

inline flatbuffers::Offset<CNode> CreateCNode(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> name = 0,
    flatbuffers::Offset<mindspore::schema::Primitive> primitive = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint32_t>> inputIndex = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint32_t>> outputIndex = 0,
    mindspore::schema::QuantType quantType = mindspore::schema::QuantType_QUANT_NONE,
    int32_t deviceType = -1) {
  CNodeBuilder builder_(_fbb);
  builder_.add_deviceType(deviceType);
  builder_.add_quantType(quantType);
  builder_.add_outputIndex(outputIndex);
  builder_.add_inputIndex(inputIndex);
  builder_.add_primitive(primitive);
  builder_.add_name(name);
  return builder_.Finish();
}

inline flatbuffers::Offset<CNode> CreateCNodeDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *name = nullptr,
    flatbuffers::Offset<mindspore::schema::Primitive> primitive = 0,
    const std::vector<uint32_t> *inputIndex = nullptr,
    const std::vector<uint32_t> *outputIndex = nullptr,
    mindspore::schema::QuantType quantType = mindspore::schema::QuantType_QUANT_NONE,
    int32_t deviceType = -1) {
  auto name__ = name ? _fbb.CreateString(name) : 0;
  auto inputIndex__ = inputIndex ? _fbb.CreateVector<uint32_t>(*inputIndex) : 0;
  auto outputIndex__ = outputIndex ? _fbb.CreateVector<uint32_t>(*outputIndex) : 0;
  return mindspore::schema::CreateCNode(
      _fbb,
      name__,
      primitive,
      inputIndex__,
      outputIndex__,
      quantType,
      deviceType);
}

struct SubGraph FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef SubGraphBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_NAME = 4,
    VT_INPUTINDICES = 6,
    VT_OUTPUTINDICES = 8,
    VT_NODEINDICES = 10,
    VT_TENSORINDICES = 12
  };
  const flatbuffers::String *name() const {
    return GetPointer<const flatbuffers::String *>(VT_NAME);
  }
  const flatbuffers::Vector<uint32_t> *inputIndices() const {
    return GetPointer<const flatbuffers::Vector<uint32_t> *>(VT_INPUTINDICES);
  }
  const flatbuffers::Vector<uint32_t> *outputIndices() const {
    return GetPointer<const flatbuffers::Vector<uint32_t> *>(VT_OUTPUTINDICES);
  }
  const flatbuffers::Vector<uint32_t> *nodeIndices() const {
    return GetPointer<const flatbuffers::Vector<uint32_t> *>(VT_NODEINDICES);
  }
  const flatbuffers::Vector<uint32_t> *tensorIndices() const {
    return GetPointer<const flatbuffers::Vector<uint32_t> *>(VT_TENSORINDICES);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyOffset(verifier, VT_INPUTINDICES) &&
           verifier.VerifyVector(inputIndices()) &&
           VerifyOffset(verifier, VT_OUTPUTINDICES) &&
           verifier.VerifyVector(outputIndices()) &&
           VerifyOffset(verifier, VT_NODEINDICES) &&
           verifier.VerifyVector(nodeIndices()) &&
           VerifyOffset(verifier, VT_TENSORINDICES) &&
           verifier.VerifyVector(tensorIndices()) &&
           verifier.EndTable();
  }
};

struct SubGraphBuilder {
  typedef SubGraph Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_name(flatbuffers::Offset<flatbuffers::String> name) {
    fbb_.AddOffset(SubGraph::VT_NAME, name);
  }
  void add_inputIndices(flatbuffers::Offset<flatbuffers::Vector<uint32_t>> inputIndices) {
    fbb_.AddOffset(SubGraph::VT_INPUTINDICES, inputIndices);
  }
  void add_outputIndices(flatbuffers::Offset<flatbuffers::Vector<uint32_t>> outputIndices) {
    fbb_.AddOffset(SubGraph::VT_OUTPUTINDICES, outputIndices);
  }
  void add_nodeIndices(flatbuffers::Offset<flatbuffers::Vector<uint32_t>> nodeIndices) {
    fbb_.AddOffset(SubGraph::VT_NODEINDICES, nodeIndices);
  }
  void add_tensorIndices(flatbuffers::Offset<flatbuffers::Vector<uint32_t>> tensorIndices) {
    fbb_.AddOffset(SubGraph::VT_TENSORINDICES, tensorIndices);
  }
  explicit SubGraphBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<SubGraph> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<SubGraph>(end);
    return o;
  }
};

inline flatbuffers::Offset<SubGraph> CreateSubGraph(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> name = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint32_t>> inputIndices = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint32_t>> outputIndices = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint32_t>> nodeIndices = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint32_t>> tensorIndices = 0) {
  SubGraphBuilder builder_(_fbb);
  builder_.add_tensorIndices(tensorIndices);
  builder_.add_nodeIndices(nodeIndices);
  builder_.add_outputIndices(outputIndices);
  builder_.add_inputIndices(inputIndices);
  builder_.add_name(name);
  return builder_.Finish();
}

inline flatbuffers::Offset<SubGraph> CreateSubGraphDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *name = nullptr,
    const std::vector<uint32_t> *inputIndices = nullptr,
    const std::vector<uint32_t> *outputIndices = nullptr,
    const std::vector<uint32_t> *nodeIndices = nullptr,
    const std::vector<uint32_t> *tensorIndices = nullptr) {
  auto name__ = name ? _fbb.CreateString(name) : 0;
  auto inputIndices__ = inputIndices ? _fbb.CreateVector<uint32_t>(*inputIndices) : 0;
  auto outputIndices__ = outputIndices ? _fbb.CreateVector<uint32_t>(*outputIndices) : 0;
  auto nodeIndices__ = nodeIndices ? _fbb.CreateVector<uint32_t>(*nodeIndices) : 0;
  auto tensorIndices__ = tensorIndices ? _fbb.CreateVector<uint32_t>(*tensorIndices) : 0;
  return mindspore::schema::CreateSubGraph(
      _fbb,
      name__,
      inputIndices__,
      outputIndices__,
      nodeIndices__,
      tensorIndices__);
}

struct MetaGraph FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  typedef MetaGraphBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_NAME = 4,
    VT_VERSION = 6,
    VT_FMKTYPE = 8,
    VT_INPUTINDEX = 10,
    VT_OUTPUTINDEX = 12,
    VT_MEMPOOLSIZE = 14,
    VT_NODES = 16,
    VT_ALLTENSORS = 18,
    VT_SUBGRAPH = 20,
    VT_OBFUSCATE = 22,
    VT_OBFMETADATA = 24
  };
  const flatbuffers::String *name() const {
    return GetPointer<const flatbuffers::String *>(VT_NAME);
  }
  const flatbuffers::String *version() const {
    return GetPointer<const flatbuffers::String *>(VT_VERSION);
  }
  int32_t fmkType() const {
    return GetField<int32_t>(VT_FMKTYPE, 0);
  }
  const flatbuffers::Vector<uint32_t> *inputIndex() const {
    return GetPointer<const flatbuffers::Vector<uint32_t> *>(VT_INPUTINDEX);
  }
  const flatbuffers::Vector<uint32_t> *outputIndex() const {
    return GetPointer<const flatbuffers::Vector<uint32_t> *>(VT_OUTPUTINDEX);
  }
  uint32_t mempoolSize() const {
    return GetField<uint32_t>(VT_MEMPOOLSIZE, 0);
  }
  const flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::CNode>> *nodes() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::CNode>> *>(VT_NODES);
  }
  const flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::Tensor>> *allTensors() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::Tensor>> *>(VT_ALLTENSORS);
  }
  const flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::SubGraph>> *subGraph() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::SubGraph>> *>(VT_SUBGRAPH);
  }
  bool obfuscate() const {
    return GetField<uint8_t>(VT_OBFUSCATE, 0) != 0;
  }
  const flatbuffers::Vector<uint8_t> *obfMetaData() const {
    return GetPointer<const flatbuffers::Vector<uint8_t> *>(VT_OBFMETADATA);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyOffset(verifier, VT_VERSION) &&
           verifier.VerifyString(version()) &&
           VerifyField<int32_t>(verifier, VT_FMKTYPE) &&
           VerifyOffset(verifier, VT_INPUTINDEX) &&
           verifier.VerifyVector(inputIndex()) &&
           VerifyOffset(verifier, VT_OUTPUTINDEX) &&
           verifier.VerifyVector(outputIndex()) &&
           VerifyField<uint32_t>(verifier, VT_MEMPOOLSIZE) &&
           VerifyOffset(verifier, VT_NODES) &&
           verifier.VerifyVector(nodes()) &&
           verifier.VerifyVectorOfTables(nodes()) &&
           VerifyOffset(verifier, VT_ALLTENSORS) &&
           verifier.VerifyVector(allTensors()) &&
           verifier.VerifyVectorOfTables(allTensors()) &&
           VerifyOffset(verifier, VT_SUBGRAPH) &&
           verifier.VerifyVector(subGraph()) &&
           verifier.VerifyVectorOfTables(subGraph()) &&
           VerifyField<uint8_t>(verifier, VT_OBFUSCATE) &&
           VerifyOffset(verifier, VT_OBFMETADATA) &&
           verifier.VerifyVector(obfMetaData()) &&
           verifier.EndTable();
  }
};

struct MetaGraphBuilder {
  typedef MetaGraph Table;
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_name(flatbuffers::Offset<flatbuffers::String> name) {
    fbb_.AddOffset(MetaGraph::VT_NAME, name);
  }
  void add_version(flatbuffers::Offset<flatbuffers::String> version) {
    fbb_.AddOffset(MetaGraph::VT_VERSION, version);
  }
  void add_fmkType(int32_t fmkType) {
    fbb_.AddElement<int32_t>(MetaGraph::VT_FMKTYPE, fmkType, 0);
  }
  void add_inputIndex(flatbuffers::Offset<flatbuffers::Vector<uint32_t>> inputIndex) {
    fbb_.AddOffset(MetaGraph::VT_INPUTINDEX, inputIndex);
  }
  void add_outputIndex(flatbuffers::Offset<flatbuffers::Vector<uint32_t>> outputIndex) {
    fbb_.AddOffset(MetaGraph::VT_OUTPUTINDEX, outputIndex);
  }
  void add_mempoolSize(uint32_t mempoolSize) {
    fbb_.AddElement<uint32_t>(MetaGraph::VT_MEMPOOLSIZE, mempoolSize, 0);
  }
  void add_nodes(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::CNode>>> nodes) {
    fbb_.AddOffset(MetaGraph::VT_NODES, nodes);
  }
  void add_allTensors(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::Tensor>>> allTensors) {
    fbb_.AddOffset(MetaGraph::VT_ALLTENSORS, allTensors);
  }
  void add_subGraph(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::SubGraph>>> subGraph) {
    fbb_.AddOffset(MetaGraph::VT_SUBGRAPH, subGraph);
  }
  void add_obfuscate(bool obfuscate) {
    fbb_.AddElement<uint8_t>(MetaGraph::VT_OBFUSCATE, static_cast<uint8_t>(obfuscate), 0);
  }
  void add_obfMetaData(flatbuffers::Offset<flatbuffers::Vector<uint8_t>> obfMetaData) {
    fbb_.AddOffset(MetaGraph::VT_OBFMETADATA, obfMetaData);
  }
  explicit MetaGraphBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  flatbuffers::Offset<MetaGraph> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<MetaGraph>(end);
    return o;
  }
};

inline flatbuffers::Offset<MetaGraph> CreateMetaGraph(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> name = 0,
    flatbuffers::Offset<flatbuffers::String> version = 0,
    int32_t fmkType = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint32_t>> inputIndex = 0,
    flatbuffers::Offset<flatbuffers::Vector<uint32_t>> outputIndex = 0,
    uint32_t mempoolSize = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::CNode>>> nodes = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::Tensor>>> allTensors = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<mindspore::schema::SubGraph>>> subGraph = 0,
    bool obfuscate = false,
    flatbuffers::Offset<flatbuffers::Vector<uint8_t>> obfMetaData = 0) {
  MetaGraphBuilder builder_(_fbb);
  builder_.add_obfMetaData(obfMetaData);
  builder_.add_subGraph(subGraph);
  builder_.add_allTensors(allTensors);
  builder_.add_nodes(nodes);
  builder_.add_mempoolSize(mempoolSize);
  builder_.add_outputIndex(outputIndex);
  builder_.add_inputIndex(inputIndex);
  builder_.add_fmkType(fmkType);
  builder_.add_version(version);
  builder_.add_name(name);
  builder_.add_obfuscate(obfuscate);
  return builder_.Finish();
}

inline flatbuffers::Offset<MetaGraph> CreateMetaGraphDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *name = nullptr,
    const char *version = nullptr,
    int32_t fmkType = 0,
    const std::vector<uint32_t> *inputIndex = nullptr,
    const std::vector<uint32_t> *outputIndex = nullptr,
    uint32_t mempoolSize = 0,
    const std::vector<flatbuffers::Offset<mindspore::schema::CNode>> *nodes = nullptr,
    const std::vector<flatbuffers::Offset<mindspore::schema::Tensor>> *allTensors = nullptr,
    const std::vector<flatbuffers::Offset<mindspore::schema::SubGraph>> *subGraph = nullptr,
    bool obfuscate = false,
    const std::vector<uint8_t> *obfMetaData = nullptr) {
  auto name__ = name ? _fbb.CreateString(name) : 0;
  auto version__ = version ? _fbb.CreateString(version) : 0;
  auto inputIndex__ = inputIndex ? _fbb.CreateVector<uint32_t>(*inputIndex) : 0;
  auto outputIndex__ = outputIndex ? _fbb.CreateVector<uint32_t>(*outputIndex) : 0;
  auto nodes__ = nodes ? _fbb.CreateVector<flatbuffers::Offset<mindspore::schema::CNode>>(*nodes) : 0;
  auto allTensors__ = allTensors ? _fbb.CreateVector<flatbuffers::Offset<mindspore::schema::Tensor>>(*allTensors) : 0;
  auto subGraph__ = subGraph ? _fbb.CreateVector<flatbuffers::Offset<mindspore::schema::SubGraph>>(*subGraph) : 0;
  auto obfMetaData__ = obfMetaData ? _fbb.CreateVector<uint8_t>(*obfMetaData) : 0;
  return mindspore::schema::CreateMetaGraph(
      _fbb,
      name__,
      version__,
      fmkType,
      inputIndex__,
      outputIndex__,
      mempoolSize,
      nodes__,
      allTensors__,
      subGraph__,
      obfuscate,
      obfMetaData__);
}

inline const mindspore::schema::MetaGraph *GetMetaGraph(const void *buf) {
  return flatbuffers::GetRoot<mindspore::schema::MetaGraph>(buf);
}

inline const mindspore::schema::MetaGraph *GetSizePrefixedMetaGraph(const void *buf) {
  return flatbuffers::GetSizePrefixedRoot<mindspore::schema::MetaGraph>(buf);
}

inline const char *MetaGraphIdentifier() {
  return "MSL2";
}

inline bool MetaGraphBufferHasIdentifier(const void *buf) {
  return flatbuffers::BufferHasIdentifier(
      buf, MetaGraphIdentifier());
}

inline bool VerifyMetaGraphBuffer(
    flatbuffers::Verifier &verifier) {
  return verifier.VerifyBuffer<mindspore::schema::MetaGraph>(MetaGraphIdentifier());
}

inline bool VerifySizePrefixedMetaGraphBuffer(
    flatbuffers::Verifier &verifier) {
  return verifier.VerifySizePrefixedBuffer<mindspore::schema::MetaGraph>(MetaGraphIdentifier());
}

inline const char *MetaGraphExtension() {
  return "ms";
}

inline void FinishMetaGraphBuffer(
    flatbuffers::FlatBufferBuilder &fbb,
    flatbuffers::Offset<mindspore::schema::MetaGraph> root) {
  fbb.Finish(root, MetaGraphIdentifier());
}

inline void FinishSizePrefixedMetaGraphBuffer(
    flatbuffers::FlatBufferBuilder &fbb,
    flatbuffers::Offset<mindspore::schema::MetaGraph> root) {
  fbb.FinishSizePrefixed(root, MetaGraphIdentifier());
}

}  // namespace schema
}  // namespace mindspore

#endif  // FLATBUFFERS_GENERATED_MODEL_MINDSPORE_SCHEMA_H_
